/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.fengine.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.Map;
import mrtjp.fengine.api.ICAssembler;
import mrtjp.fengine.api.ICFlatMap;
import mrtjp.fengine.api.ICStepThroughAssembler;
import mrtjp.fengine.assemble.ICAssemblerImpl;
import mrtjp.fengine.assemble.ICStepThroughAssemblerImpl;
import mrtjp.fengine.serialize.RuntimeTypeAdapterFactory;
import mrtjp.fengine.simulate.ByteRegister;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICRegister;
import mrtjp.fengine.simulate.ICSimulation;
import mrtjp.fengine.simulate.StaticByteRegister;
import mrtjp.fengine.tiles.FETile;

public abstract class FabricationEngine {
    private final Gson serializer = this.createSerializer();

    public ICAssembler newAssembler() {
        return new ICAssemblerImpl();
    }

    public ICStepThroughAssembler newStepThroughAssembler() {
        return new ICStepThroughAssemblerImpl();
    }

    private Gson createSerializer() {
        RuntimeTypeAdapterFactory<FETile> tileAdapterFactory = RuntimeTypeAdapterFactory.of(FETile.class);
        for (Map.Entry<Class<? extends FETile>, String> entry : this.getTileSerializationMap().entrySet()) {
            tileAdapterFactory.registerSubtype(entry.getKey(), entry.getValue());
        }
        RuntimeTypeAdapterFactory<ICGate> gateAdapterFactory = RuntimeTypeAdapterFactory.of(ICGate.class);
        for (Map.Entry<Class<? extends ICGate>, String> entry : this.getGateSerializationMap().entrySet()) {
            gateAdapterFactory.registerSubtype(entry.getKey(), entry.getValue());
        }
        RuntimeTypeAdapterFactory<ICRegister> runtimeTypeAdapterFactory = RuntimeTypeAdapterFactory.of(ICRegister.class);
        runtimeTypeAdapterFactory.registerSubtype(ByteRegister.class);
        runtimeTypeAdapterFactory.registerSubtype(StaticByteRegister.class);
        for (Map.Entry<Class<? extends ICRegister>, String> entry : this.getRegisterSerializationMap().entrySet()) {
            runtimeTypeAdapterFactory.registerSubtype(entry.getKey(), entry.getValue());
        }
        return new GsonBuilder().registerTypeAdapterFactory(tileAdapterFactory).registerTypeAdapterFactory(gateAdapterFactory).registerTypeAdapterFactory(runtimeTypeAdapterFactory).enableComplexMapKeySerialization().create();
    }

    public String serializeFlatMap(ICFlatMap flatMap) {
        return this.serializer.toJson((Object)flatMap, ICFlatMap.class);
    }

    public ICFlatMap deserializeFlatMap(String flatMap) {
        try {
            return (ICFlatMap)this.serializer.fromJson(flatMap, ICFlatMap.class);
        }
        catch (JsonSyntaxException e) {
            System.out.println("Failed to deserialize ICFlatMap: " + e.getMessage());
            return null;
        }
    }

    public String serializeSimulation(ICSimulation simulation) {
        return this.serializer.toJson((Object)simulation, ICSimulation.class);
    }

    public ICSimulation deserializeSimulation(String simulation) {
        try {
            return (ICSimulation)this.serializer.fromJson(simulation, ICSimulation.class);
        }
        catch (JsonSyntaxException e) {
            System.out.println("Failed to deserialize ICSimulation: " + e.getMessage());
            return null;
        }
    }

    public Map<Class<? extends FETile>, String> getTileSerializationMap() {
        return Collections.emptyMap();
    }

    public Map<Class<? extends ICGate>, String> getGateSerializationMap() {
        return Collections.emptyMap();
    }

    public Map<Class<? extends ICRegister>, String> getRegisterSerializationMap() {
        return Collections.emptyMap();
    }
}

