/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine;

public interface IRotatableICTile {
    public int getRotation();

    public void setRotation(int var1);

    default public int toInternalRotation(int absRot) {
        return (absRot + 6 - this.getRotation()) % 4;
    }

    default public int toAbsoluteRotation(int r) {
        return (r + 2 + this.getRotation()) % 4;
    }

    default public int toInternalMask(int absMask) {
        return IRotatableICTile.shiftMask(absMask, this.toInternalRotation(0));
    }

    default public int toAbsoluteMask(int intMask) {
        return IRotatableICTile.shiftMask(intMask, this.toAbsoluteRotation(0));
    }

    public static int rotationToDir(int r) {
        return switch (r) {
            case 0 -> 3;
            case 1 -> 4;
            case 2 -> 2;
            case 3 -> 5;
            default -> -1;
        };
    }

    public static int dirToRotation(int dir) {
        return switch (dir) {
            case 2 -> 2;
            case 3 -> 0;
            case 4 -> 1;
            case 5 -> 3;
            default -> -1;
        };
    }

    public static int dirMaskToRotationMask(int connMask) {
        int rMask = 0;
        for (int r = 0; r < 4; ++r) {
            int s = IRotatableICTile.rotationToDir(r);
            if ((connMask & 1 << s) == 0) continue;
            rMask |= 1 << r;
        }
        return rMask;
    }

    public static int shiftMask(int mask, int r) {
        return mask & 0xFFFFFFF0 | (mask << r | mask >> 4 - r) & 0xF;
    }

    public static int flipMaskZ(int mask) {
        return mask & 5 | mask << 2 & 8 | mask >> 2 & 2;
    }
}

