/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import mrtjp.projectred.fabrication.engine.IBundledConnectableICTile;
import mrtjp.projectred.fabrication.engine.IConnectableICTile;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.RedstoneGateTile;

public class BundledGateTile
extends RedstoneGateTile
implements IBundledConnectableICTile {
    public BundledGateTile(ICGateTileType gateType) {
        super(gateType);
    }

    @Override
    protected boolean canGateConnectTo(IConnectableICTile target, int r) {
        if (target instanceof IBundledConnectableICTile) {
            return this.canConnectBundled(r);
        }
        return super.canGateConnectTo(target, r);
    }

    protected boolean canConnectBundled(int r) {
        return this.canInputBundled(r) || this.canOutputBundled(r);
    }

    protected boolean canOutputBundled(int r) {
        return (this.bundledOutputMask() & 1 << r) != 0;
    }

    protected boolean canInputBundled(int r) {
        return (this.bundledInputMask() & 1 << r) != 0;
    }

    protected int bundledOutputMask() {
        return 0;
    }

    protected int bundledInputMask() {
        return 0;
    }
}

