/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.simulate.ByteRegister;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICSimulation;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.tools.InteractionZone;
import mrtjp.projectred.fabrication.editor.tools.SimpleInteractionZone;
import mrtjp.projectred.fabrication.engine.ICSimulationContainer;
import mrtjp.projectred.fabrication.engine.IRotatableICTile;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.InternalStateGateTile;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CounterGateTile
extends InternalStateGateTile {
    private static final int KEY_VALUE = 10;
    private static final int KEY_MAX = 11;
    private static final int KEY_INCR = 12;
    private static final int KEY_DECR = 13;
    private int[] countRegs = new int[]{-1, -1};
    private int value = 0;
    private int max = 10;
    private int incr = 1;
    private int decr = 1;

    public CounterGateTile() {
        super(ICGateTileType.COUNTER);
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128385_("reg_count", this.countRegs);
        tag.m_128376_("val", (short)this.value);
        tag.m_128376_("max", (short)this.max);
        tag.m_128376_("inc", (short)this.incr);
        tag.m_128376_("dec", (short)this.decr);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.countRegs = tag.m_128465_("reg_count");
        this.value = tag.m_128448_("val") & 0xFFFF;
        this.max = tag.m_128448_("max") & 0xFFFF;
        this.incr = tag.m_128448_("inc") & 0xFFFF;
        this.decr = tag.m_128448_("dec") & 0xFFFF;
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeShort(this.value);
        packet.writeShort(this.max);
        packet.writeShort(this.incr);
        packet.writeShort(this.decr);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.value = packet.readUShort();
        this.max = packet.readUShort();
        this.incr = packet.readUShort();
        this.decr = packet.readUShort();
    }

    @Override
    public void read(MCDataInput packet, int key) {
        switch (key) {
            case 10: {
                this.value = packet.readUShort();
                break;
            }
            case 11: {
                this.max = packet.readUShort();
                break;
            }
            case 12: {
                this.incr = packet.readUShort();
                break;
            }
            case 13: {
                this.decr = packet.readUShort();
                break;
            }
            default: {
                super.read(packet, key);
            }
        }
    }

    protected void sendValueUpdate() {
        this.getWriteStream(10).writeShort(this.value);
    }

    protected void sendMaxUpdate() {
        this.getWriteStream(11).writeShort(this.max);
    }

    protected void sendIncrUpdate() {
        this.getWriteStream(12).writeShort(this.incr);
    }

    protected void sendDecrUpdate() {
        this.getWriteStream(13).writeShort(this.decr);
    }

    @Override
    public void onSimRegistersChanged(int rMask, ICSimulationContainer container) {
        super.onSimRegistersChanged(rMask, container);
        int value = container.pullShortValue(this.countRegs, 0) & 0xFFFF;
        if (value != this.value) {
            this.value = value;
            this.sendValueUpdate();
        }
    }

    @Override
    public void buildToolTip(List<Component> toolTip) {
        super.buildToolTip(toolTip);
        toolTip.add((Component)Component.m_237115_((String)"projectred_fabrication.tiles.counter.value").m_7220_((Component)Component.m_237113_((String)(": " + this.value))).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
        toolTip.add((Component)Component.m_237115_((String)"projectred_fabrication.tiles.counter.max").m_7220_((Component)Component.m_237113_((String)(": " + this.max))).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
        toolTip.add((Component)Component.m_237115_((String)"projectred_fabrication.tiles.counter.incr").m_7220_((Component)Component.m_237113_((String)(": " + this.incr))).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
        toolTip.add((Component)Component.m_237115_((String)"projectred_fabrication.tiles.counter.decr").m_7220_((Component)Component.m_237113_((String)(": " + this.decr))).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
    }

    @Override
    public void buildInteractionZoneList(List<InteractionZone> zones) {
        super.buildInteractionZoneList(zones);
        double w = 0.125;
        double h = 0.03125;
        double l = 0.0625;
        double x = 0.0;
        double y = 0.125;
        double z = 0.0;
        int[] deltas = new int[]{-10, -5, -1, 1, 5, 10};
        String[] names = new String[]{"projectred_fabrication.tiles.counter.max", "projectred_fabrication.tiles.counter.incr", "projectred_fabrication.tiles.counter.decr"};
        List<Consumer<Integer>> actions = List.of(this::addMax, this::addIncr, this::addDecr);
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 6; ++i) {
                Consumer<Integer> action = actions.get(j);
                int delta = deltas[i];
                MutableComponent text = Component.m_237113_((String)"%+d".formatted(deltas[i]));
                MutableComponent toolTip = Component.m_237115_((String)names[j]).m_7220_((Component)Component.m_237113_((String)" %+d".formatted(deltas[i]))).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY);
                Cuboid6 box = new Cuboid6(0.0, 0.0, 0.0, w, h, l).add(x + (double)i < 3.0 ? (double)i * w : 1.0 - 3.0 * w + (double)(i - 3) * w, y, z + (double)j * l);
                zones.add(new SimpleInteractionZone.Builder().bounds(box).boundingBoxLineWidth(2.0).leftClickAction(() -> action.accept(delta)).text((Component)text).tooltip((Component)toolTip).build());
            }
        }
    }

    private void addMax(int delta) {
        int oldMax = this.max;
        this.max = Math.max(1, Math.min(this.max + delta, Short.MAX_VALUE));
        if (this.max != oldMax) {
            this.sendMaxUpdate();
            if (this.incr > this.max) {
                this.incr = this.max;
                this.sendIncrUpdate();
            }
            if (this.decr > this.max) {
                this.decr = this.max;
                this.sendDecrUpdate();
            }
            this.getEditor().markTileChange();
        }
    }

    private void addIncr(int delta) {
        int oldIncr = this.incr;
        this.incr = Math.max(1, Math.min(this.incr + delta, this.max));
        if (this.incr != oldIncr) {
            this.sendIncrUpdate();
            this.getEditor().markTileChange();
        }
    }

    private void addDecr(int delta) {
        int oldDecr = this.decr;
        this.decr = Math.max(1, Math.min(this.decr + delta, this.max));
        if (this.decr != oldDecr) {
            this.sendDecrUpdate();
            this.getEditor().markTileChange();
        }
    }

    @Override
    protected void reflectAndSend() {
        this.configureShapeAndSend(this.getShape() == 0 ? 1 : 0);
    }

    @Override
    protected boolean canReflect() {
        return true;
    }

    public boolean isPointerStarted() {
        return this.getEditor().getStateMachine().isSimulating();
    }

    public int pointerValue() {
        return this.value;
    }

    public int pointerMax() {
        return this.max;
    }

    @Override
    public int state() {
        int state = super.state();
        return this.getShape() == 0 ? state : state & 0xF0 | IRotatableICTile.flipMaskZ(state) & 0xF;
    }

    @Override
    protected int redstoneOutputMask() {
        return 5;
    }

    @Override
    protected int redstoneInputMask() {
        return 10;
    }

    @Override
    protected void clearRegisterIds() {
        super.clearRegisterIds();
        Arrays.fill(this.countRegs, -1);
    }

    @Override
    public void allocate(ICAssemblyTile.Allocator allocator) {
        super.allocate(allocator);
        for (int i = 0; i < 2; ++i) {
            this.countRegs[i] = allocator.allocRegisterID();
        }
    }

    @Override
    public void consumeRemaps(ICAssemblyTile.RemapProvider remapProvider) {
        super.consumeRemaps(remapProvider);
        for (int i = 0; i < 2; ++i) {
            this.countRegs[i] = remapProvider.getRemappedRegisterID(this.countRegs[i]);
        }
    }

    @Override
    public void collect(ICAssemblyTile.Collector collector) {
        super.collect(collector);
        for (int i = 0; i < 2; ++i) {
            collector.addRegister(this.countRegs[i], new ByteRegister());
        }
    }

    @Override
    protected void collectGate(ICAssemblyTile.Collector collector, int gateId, int[] inputRegisters, int[] outputRegisters) {
        int i;
        ArrayList<Integer> inputRegs = new ArrayList<Integer>();
        ArrayList<Integer> outputRegs = new ArrayList<Integer>();
        inputRegs.add(this.stateReg);
        inputRegs.add(inputRegisters[this.getShape() == 0 ? 1 : 3]);
        inputRegs.add(inputRegisters[this.getShape() == 0 ? 3 : 1]);
        for (i = 0; i < 2; ++i) {
            inputRegs.add(this.countRegs[i]);
        }
        outputRegs.add(this.stateReg);
        outputRegs.add(outputRegisters[0]);
        outputRegs.add(outputRegisters[2]);
        for (i = 0; i < 2; ++i) {
            outputRegs.add(this.countRegs[i]);
        }
        collector.addGate(gateId, new CounterGate(this.max, this.incr, this.decr), inputRegs, outputRegs);
    }

    public static class CounterGate
    implements ICGate {
        private final int max;
        private final int incr;
        private final int decr;

        public CounterGate(int max, int incr, int decr) {
            this.max = max;
            this.incr = incr;
            this.decr = decr;
        }

        private static byte readState(ICSimulation ic, int[] inputs) {
            return ic.getRegByteVal(inputs[0]);
        }

        private static byte readInputMask(ICSimulation ic, int[] inputs) {
            int mask = 0;
            if (ic.getRegByteVal(inputs[1]) != 0) {
                mask |= 2;
            }
            if (ic.getRegByteVal(inputs[2]) != 0) {
                mask |= 8;
            }
            return (byte)mask;
        }

        private static short readCount(ICSimulation ic, int[] inputs) {
            return ic.getRegShortVal(inputs, 3);
        }

        private static void writeState(ICSimulation ic, int[] outputs, byte state) {
            ic.queueRegByteVal(outputs[0], state);
        }

        private static void writeOutputMask(ICSimulation ic, int[] outputs, byte oMask) {
            ic.queueRegByteVal(outputs[1], (byte)((oMask & 2) != 0 ? 1 : 0));
            ic.queueRegByteVal(outputs[2], (byte)((oMask & 4) != 0 ? 1 : 0));
        }

        private static void writeCount(ICSimulation ic, int[] outputs, short count) {
            ic.queueRegShortVal(outputs, 3, count);
        }

        @Override
        public void compute(ICSimulation ic, int[] inputs, int[] outputs) {
            byte stateVal = CounterGate.readState(ic, inputs);
            int state = stateVal & 0xF;
            int prevInputMask = stateVal >> 4 & 0xF;
            byte inputMask = CounterGate.readInputMask(ic, inputs);
            int highMask = inputMask & ~prevInputMask;
            switch (state) {
                case 0: {
                    CounterGate.writeState(ic, outputs, (byte)1);
                    CounterGate.writeOutputMask(ic, outputs, (byte)4);
                    CounterGate.writeCount(ic, outputs, (short)0);
                    break;
                }
                case 1: {
                    if (highMask == 2) {
                        int newCount = Math.min(this.max, (CounterGate.readCount(ic, inputs) & 0xFFFF) + this.incr);
                        CounterGate.writeCount(ic, outputs, (short)newCount);
                        CounterGate.writeOutputMask(ic, outputs, (byte)(newCount == this.max ? 2 : 0));
                    } else if (highMask == 8) {
                        int newCount = Math.max(0, (CounterGate.readCount(ic, inputs) & 0xFFFF) - this.decr);
                        CounterGate.writeCount(ic, outputs, (short)newCount);
                        CounterGate.writeOutputMask(ic, outputs, (byte)(newCount == 0 ? 4 : 0));
                    }
                    CounterGate.writeState(ic, outputs, (byte)(inputMask << 4 | 1));
                    break;
                }
                default: {
                    ProjectRedFabrication.LOGGER.error("Invalid state: " + state);
                    CounterGate.writeState(ic, outputs, (byte)0);
                }
            }
        }
    }
}

