/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import java.util.ArrayList;
import java.util.Random;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICSimulation;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.engine.PRFabricationEngine;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.SimpleTimedStateGateTile;

public class RandomizerGateTile
extends SimpleTimedStateGateTile {
    public RandomizerGateTile() {
        super(ICGateTileType.RANDOMIZER);
    }

    @Override
    protected int interactMask() {
        return 11;
    }

    @Override
    protected int getDeadSides() {
        return 3;
    }

    @Override
    protected int rotationToDeadSideBit(int r) {
        return switch (r) {
            case 0 -> 2;
            case 1 -> 1;
            case 3 -> 4;
            default -> 0;
        };
    }

    @Override
    protected int redstoneInputMask() {
        return 4;
    }

    @Override
    protected int redstoneOutputMask() {
        return ~((this.getShape() & 1) << 1 | (this.getShape() & 2) >> 1 | (this.getShape() & 4) << 1) & 0xB;
    }

    @Override
    protected void collectGate(ICAssemblyTile.Collector collector, int gateId, int[] inputRegisters, int[] outputRegisters) {
        int i;
        ArrayList<Integer> inputRegs = new ArrayList<Integer>();
        ArrayList<Integer> outputRegs = new ArrayList<Integer>();
        inputRegs.add(this.stateReg);
        inputRegs.add(inputRegisters[2]);
        for (i = 0; i < 8; ++i) {
            inputRegs.add(this.timeRegs[i]);
        }
        for (i = 0; i < 8; ++i) {
            inputRegs.add(PRFabricationEngine.REG_TIME[i]);
        }
        outputRegs.add(this.stateReg);
        outputRegs.add(outputRegisters[3] != -1 ? outputRegisters[3] : 136);
        outputRegs.add(outputRegisters[0] != -1 ? outputRegisters[0] : 136);
        outputRegs.add(outputRegisters[1] != -1 ? outputRegisters[1] : 136);
        for (i = 0; i < 8; ++i) {
            outputRegs.add(this.timeRegs[i]);
        }
        collector.addGate(gateId, new RandomizerGate(), inputRegs, outputRegs);
    }

    public static class RandomizerGate
    implements ICGate {
        private static final Random RAND = new Random();

        private static byte readState(ICSimulation ic, int[] inputs) {
            return ic.getRegByteVal(inputs[0]);
        }

        private static byte readInput(ICSimulation ic, int[] inputs) {
            return ic.getRegByteVal(inputs[1]);
        }

        private static long readSchedTime(ICSimulation ic, int[] inputs) {
            return ic.getRegLongVal(inputs, 2);
        }

        private static long readSysTime(ICSimulation ic, int[] inputs) {
            return ic.getRegLongVal(inputs, 10);
        }

        private static void writeState(ICSimulation ic, int[] outputs, byte state) {
            ic.queueRegByteVal(outputs[0], state);
        }

        private static void writeOutMask(ICSimulation ic, int[] outputs, int mask) {
            ic.queueRegByteVal(outputs[1], (byte)((mask & 1) != 0 ? 1 : 0));
            ic.queueRegByteVal(outputs[2], (byte)((mask & 2) != 0 ? 1 : 0));
            ic.queueRegByteVal(outputs[3], (byte)((mask & 4) != 0 ? 1 : 0));
        }

        private static void writeSchedTime(ICSimulation ic, int[] outputs, long time) {
            ic.queueRegLongVal(outputs, 4, time);
        }

        @Override
        public void compute(ICSimulation ic, int[] inputs, int[] outputs) {
            byte stateVal = RandomizerGate.readState(ic, inputs);
            switch (stateVal) {
                case 0: {
                    if (RandomizerGate.readInput(ic, inputs) == 0) break;
                    RandomizerGate.writeState(ic, outputs, (byte)1);
                    RandomizerGate.writeOutMask(ic, outputs, RAND.nextInt(8));
                    RandomizerGate.writeSchedTime(ic, outputs, RandomizerGate.readSysTime(ic, inputs) + 2L);
                    break;
                }
                case 1: {
                    if (RandomizerGate.readSysTime(ic, inputs) < RandomizerGate.readSchedTime(ic, inputs)) break;
                    if (RandomizerGate.readInput(ic, inputs) != 0) {
                        RandomizerGate.writeOutMask(ic, outputs, RAND.nextInt(8));
                        RandomizerGate.writeSchedTime(ic, outputs, RandomizerGate.readSysTime(ic, inputs) + 2L);
                        break;
                    }
                    RandomizerGate.writeState(ic, outputs, (byte)0);
                    RandomizerGate.writeOutMask(ic, outputs, 0);
                    break;
                }
                default: {
                    ProjectRedFabrication.LOGGER.error("Invalid state: " + stateVal);
                    RandomizerGate.writeState(ic, outputs, (byte)0);
                }
            }
        }
    }
}

