/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import java.util.ArrayList;
import java.util.Random;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICSimulation;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.InternalStateGateTile;

public class SRLatchGateTile
extends InternalStateGateTile {
    public SRLatchGateTile() {
        super(ICGateTileType.SR_LATCH);
    }

    @Override
    public void preparePlacement(int r) {
        super.preparePlacement(r);
        this.setShape(2);
    }

    @Override
    protected boolean canReflect() {
        return true;
    }

    @Override
    protected void reflectAndSend() {
        this.configureShapeAndSend(this.getShape() ^ 1);
    }

    protected void shiftModeAndSend() {
        this.configureShapeAndSend(this.getShape() ^ 2);
    }

    @Override
    protected int redstoneInputMask() {
        return 10;
    }

    @Override
    protected int redstoneOutputMask() {
        return this.getShape() >> 1 == 0 ? 15 : 5;
    }

    @Override
    protected void collectGate(ICAssemblyTile.Collector collector, int gateId, int[] inputRegisters, int[] outputRegisters) {
        ArrayList<Integer> inputRegs = new ArrayList<Integer>();
        ArrayList<Integer> outputRegs = new ArrayList<Integer>();
        boolean reflected = (this.getShape() & 1) != 0;
        boolean backfeed = (this.getShape() & 2) == 0;
        inputRegs.add(this.stateReg);
        inputRegs.add(inputRegisters[reflected ? 3 : 1]);
        inputRegs.add(inputRegisters[reflected ? 1 : 3]);
        outputRegs.add(this.stateReg);
        outputRegs.add(outputRegisters[2]);
        outputRegs.add(outputRegisters[0]);
        outputRegs.add(backfeed ? outputRegisters[reflected ? 3 : 1] : 136);
        outputRegs.add(backfeed ? outputRegisters[reflected ? 1 : 3] : 136);
        collector.addGate(gateId, new SRLatchGate(), inputRegs, outputRegs);
    }

    public static class SRLatchGate
    implements ICGate {
        private static final Random RAND = new Random();

        private static byte readState(ICSimulation ic, int[] inputs) {
            return ic.getRegByteVal(inputs[0]);
        }

        private static int readInputMask(ICSimulation ic, int[] inputs) {
            int mask = 0;
            if (ic.getRegByteVal(inputs[1]) != 0) {
                mask |= 1;
            }
            if (ic.getRegByteVal(inputs[2]) != 0) {
                mask |= 2;
            }
            return mask;
        }

        private static void writeState(ICSimulation ic, int[] outputs, byte state) {
            ic.queueRegByteVal(outputs[0], state);
        }

        private static void writeOutputMask(ICSimulation ic, int[] outputs, int mask) {
            ic.queueRegByteVal(outputs[1], (byte)((mask & 1) != 0 ? 1 : 0));
            ic.queueRegByteVal(outputs[3], (byte)((mask & 1) != 0 ? 1 : 0));
            ic.queueRegByteVal(outputs[2], (byte)((mask & 2) != 0 ? 1 : 0));
            ic.queueRegByteVal(outputs[4], (byte)((mask & 2) != 0 ? 1 : 0));
        }

        private static void enterStateA(ICSimulation ic, int[] outputs) {
            SRLatchGate.writeState(ic, outputs, (byte)1);
            SRLatchGate.writeOutputMask(ic, outputs, 1);
        }

        private static void enterStateB(ICSimulation ic, int[] outputs) {
            SRLatchGate.writeState(ic, outputs, (byte)2);
            SRLatchGate.writeOutputMask(ic, outputs, 2);
        }

        private static void enterUndefState(ICSimulation ic, int[] outputs) {
            SRLatchGate.writeState(ic, outputs, (byte)3);
            SRLatchGate.writeOutputMask(ic, outputs, 0);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void compute(ICSimulation ic, int[] inputs, int[] outputs) {
            inputMask = SRLatchGate.readInputMask(ic, inputs);
            switch (SRLatchGate.readState(ic, inputs)) {
                case 0: {
                    if (inputMask != 2) ** GOTO lbl7
                    SRLatchGate.enterStateB(ic, outputs);
                    ** GOTO lbl11
lbl7:
                    // 1 sources

                    if (inputMask == 3) {
                        SRLatchGate.enterUndefState(ic, outputs);
                    } else {
                        SRLatchGate.enterStateA(ic, outputs);
                    }
                }
lbl11:
                // 4 sources

                case 1: {
                    if (inputMask == 2) {
                        SRLatchGate.enterStateB(ic, outputs);
                        break;
                    }
                    if (inputMask != 3) break;
                    SRLatchGate.enterUndefState(ic, outputs);
                    break;
                }
                case 2: {
                    if (inputMask == 1) {
                        SRLatchGate.enterStateA(ic, outputs);
                        break;
                    }
                    if (inputMask != 3) break;
                    SRLatchGate.enterUndefState(ic, outputs);
                    break;
                }
                case 3: {
                    if (inputMask == 0) {
                        if (SRLatchGate.RAND.nextBoolean()) {
                            SRLatchGate.enterStateA(ic, outputs);
                            break;
                        }
                        SRLatchGate.enterStateB(ic, outputs);
                        break;
                    }
                    if (inputMask == 1) {
                        SRLatchGate.enterStateA(ic, outputs);
                        break;
                    }
                    if (inputMask != 2) break;
                    SRLatchGate.enterStateB(ic, outputs);
                    break;
                }
                default: {
                    ProjectRedFabrication.LOGGER.error("Invalid state: " + SRLatchGate.readState(ic, inputs));
                    SRLatchGate.writeState(ic, outputs, (byte)0);
                }
            }
        }
    }
}

