/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.ArrayList;
import java.util.List;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICSimulation;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.tools.InteractionZone;
import mrtjp.projectred.fabrication.engine.PRFabricationEngine;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.SidedRedstoneGateTile;
import mrtjp.projectred.fabrication.engine.gates.TimerGateTile;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public class SequencerGateTile
extends SidedRedstoneGateTile {
    public static final int MAX_TIME_PACKET = 16;
    private int pointerMax = 38;

    public SequencerGateTile() {
        super(ICGateTileType.SEQUENCER);
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128405_("tmax", this.pointerMax);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.pointerMax = tag.m_128451_("tmax");
    }

    @Override
    public void writeDesc(MCDataOutput out) {
        super.writeDesc(out);
        out.writeInt(this.pointerMax);
    }

    @Override
    public void readDesc(MCDataInput in) {
        super.readDesc(in);
        this.pointerMax = in.readInt();
    }

    @Override
    public void read(MCDataInput in, int key) {
        switch (key) {
            case 16: {
                this.pointerMax = in.readInt();
                break;
            }
            default: {
                super.read(in, key);
            }
        }
    }

    protected void sendMaxTimeUpdate() {
        this.getWriteStream(16).writeInt(this.pointerMax);
    }

    @Override
    public void buildToolTip(List<Component> toolTip) {
        super.buildToolTip(toolTip);
        int tmax = this.pointerMax + 2;
        double smax = (double)tmax * 0.05;
        toolTip.add((Component)Component.m_237115_((String)"projectred_fabrication.tiles.timer.interval").m_7220_((Component)Component.m_237113_((String)": %.2fs (%d ".formatted(smax, tmax))).m_7220_((Component)Component.m_237115_((String)"projectred_fabrication.unit.ticks")).m_7220_((Component)Component.m_237113_((String)")")).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
    }

    @Override
    public void buildInteractionZoneList(List<InteractionZone> zones) {
        super.buildInteractionZoneList(zones);
        TimerGateTile.addTimerAdjustmentInteractionZones(zones, this::addTimerMax);
    }

    private void addTimerMax(int delta) {
        int newMax = this.pointerMax + delta;
        int min = Math.max(4, Configurator.minTimerTicks) - 2;
        if (newMax < min) {
            newMax = min;
        }
        if (newMax != this.pointerMax) {
            this.pointerMax = newMax;
            this.sendMaxTimeUpdate();
            this.getEditor().markTileChange();
        }
    }

    @Override
    protected boolean canReflect() {
        return true;
    }

    @Override
    protected void reflectAndSend() {
        this.configureShapeAndSend(this.getShape() == 0 ? 1 : 0);
    }

    @Override
    protected int redstoneOutputMask() {
        return 15;
    }

    public boolean isPointerStarted() {
        return this.getEditor().getStateMachine().isSimulating();
    }

    public int pointerMax() {
        return this.pointerMax;
    }

    public int pointerValue() {
        long simTime = this.getEditor().getStateMachine().getSimSystemTime();
        return (int)(simTime % ((long)this.pointerMax * 4L));
    }

    @Override
    protected void collectGate(ICAssemblyTile.Collector collector, int gateId, int[] inputRegisters, int[] outputRegisters) {
        ArrayList<Integer> inputRegs = new ArrayList<Integer>();
        ArrayList<Integer> outputRegs = new ArrayList<Integer>();
        for (int i = 0; i < 8; ++i) {
            inputRegs.add(PRFabricationEngine.REG_TIME[i]);
        }
        outputRegs.add(outputRegisters[0]);
        outputRegs.add(outputRegisters[this.getShape() == 0 ? 1 : 3]);
        outputRegs.add(outputRegisters[2]);
        outputRegs.add(outputRegisters[this.getShape() == 0 ? 3 : 1]);
        collector.addGate(gateId, new SequencerGate(this.pointerMax), inputRegs, outputRegs);
    }

    public static class SequencerGate
    implements ICGate {
        private final long pointerMax;

        public SequencerGate(long pointerMax) {
            this.pointerMax = pointerMax;
        }

        private static long readSysTime(ICSimulation ic, int[] inputs) {
            return ic.getRegLongVal(inputs, 0);
        }

        private static void writeOutputMask(ICSimulation ic, int[] outputs, int mask) {
            ic.queueRegByteVal(outputs[0], (byte)((mask & 1) != 0 ? 1 : 0));
            ic.queueRegByteVal(outputs[1], (byte)((mask & 2) != 0 ? 1 : 0));
            ic.queueRegByteVal(outputs[2], (byte)((mask & 4) != 0 ? 1 : 0));
            ic.queueRegByteVal(outputs[3], (byte)((mask & 8) != 0 ? 1 : 0));
        }

        @Override
        public void compute(ICSimulation ic, int[] inputs, int[] outputs) {
            long sysTime = SequencerGate.readSysTime(ic, inputs);
            int mask = 1 << (int)(sysTime % (this.pointerMax * 4L) / this.pointerMax);
            SequencerGate.writeOutputMask(ic, outputs, mask);
        }
    }
}

