/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import java.util.ArrayList;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICSimulation;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.InternalStateGateTile;

public class TransparentLatchGateTile
extends InternalStateGateTile {
    public TransparentLatchGateTile() {
        super(ICGateTileType.TRANSPARENT_LATCH);
    }

    @Override
    protected boolean canReflect() {
        return true;
    }

    @Override
    protected void reflectAndSend() {
        this.configureShapeAndSend((this.getShape() + 1) % 2);
    }

    @Override
    protected int redstoneInputMask() {
        return this.getShape() == 0 ? 12 : 6;
    }

    @Override
    protected int redstoneOutputMask() {
        return this.getShape() == 0 ? 3 : 9;
    }

    @Override
    protected void collectGate(ICAssemblyTile.Collector collector, int gateId, int[] inputRegisters, int[] outputRegisters) {
        ArrayList<Integer> inputRegs = new ArrayList<Integer>();
        ArrayList<Integer> outputRegs = new ArrayList<Integer>();
        inputRegs.add(this.stateReg);
        inputRegs.add(inputRegisters[this.getShape() == 0 ? 3 : 1]);
        inputRegs.add(inputRegisters[2]);
        outputRegs.add(this.stateReg);
        outputRegs.add(outputRegisters[0]);
        outputRegs.add(outputRegisters[this.getShape() == 0 ? 1 : 3]);
        collector.addGate(gateId, new TransparentLatchGate(), inputRegs, outputRegs);
    }

    public static class TransparentLatchGate
    implements ICGate {
        private static byte readState(ICSimulation ic, int[] inputs) {
            return ic.getRegByteVal(inputs[0]);
        }

        private static byte readData(ICSimulation ic, int[] inputs) {
            return ic.getRegByteVal(inputs[1]);
        }

        private static boolean writeEnabled(ICSimulation ic, int[] inputs) {
            return ic.getRegByteVal(inputs[2]) != 0;
        }

        private static void writeState(ICSimulation ic, int[] outputs, byte state) {
            ic.queueRegByteVal(outputs[0], state);
        }

        private static void writeData(ICSimulation ic, int[] outputs, byte data) {
            ic.queueRegByteVal(outputs[1], data);
            ic.queueRegByteVal(outputs[2], data);
        }

        @Override
        public void compute(ICSimulation ic, int[] inputs, int[] outputs) {
            switch (TransparentLatchGate.readState(ic, inputs)) {
                case 0: {
                    if (TransparentLatchGate.writeEnabled(ic, inputs)) {
                        TransparentLatchGate.writeState(ic, outputs, (byte)2);
                        break;
                    }
                    TransparentLatchGate.writeState(ic, outputs, (byte)1);
                    break;
                }
                case 1: {
                    if (!TransparentLatchGate.writeEnabled(ic, inputs)) break;
                    TransparentLatchGate.writeState(ic, outputs, (byte)2);
                    break;
                }
                case 2: {
                    if (TransparentLatchGate.writeEnabled(ic, inputs)) {
                        TransparentLatchGate.writeData(ic, outputs, TransparentLatchGate.readData(ic, inputs));
                        break;
                    }
                    TransparentLatchGate.writeState(ic, outputs, (byte)1);
                    break;
                }
                default: {
                    ProjectRedFabrication.LOGGER.error("Invalid state: " + TransparentLatchGate.readState(ic, inputs));
                    TransparentLatchGate.writeState(ic, outputs, (byte)0);
                }
            }
        }
    }
}

