/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;

public class LinearVectorAnimation {
    public final Vector3 vector;
    private final Cuboid6 bounds = new Cuboid6(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final Vector3 step = new Vector3();
    private long lastTime = -1L;
    private long stepsRemaining = 0L;

    public LinearVectorAnimation() {
        this(0.0, 0.0, 0.0);
    }

    public LinearVectorAnimation(double x, double y, double z) {
        this.vector = new Vector3(x, y, z);
    }

    public void setBounds(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        this.bounds.min.set(xmin, ymin, zmin);
        this.bounds.max.set(xmax, ymax, zmax);
        if (!this.bounds.contains(this.vector)) {
            this.vector.x = Math.max(this.bounds.min.x, Math.min(this.bounds.max.x, this.vector.x));
            this.vector.y = Math.max(this.bounds.min.y, Math.min(this.bounds.max.y, this.vector.y));
            this.vector.z = Math.max(this.bounds.min.z, Math.min(this.bounds.max.z, this.vector.z));
        }
    }

    public void addDeltaWithNewDuration(Vector3 delta, long duration) {
        if (delta.equals((Object)Vector3.ZERO) || duration == 0L) {
            return;
        }
        this.step.multiply((double)this.stepsRemaining);
        this.step.add(delta);
        this.stepsRemaining = duration;
        this.step.divide((double)this.stepsRemaining);
    }

    public void moveToTargetWithDuration(Vector3 target, long duration) {
        this.stepsRemaining = duration;
        this.step.set(target).subtract(this.vector).divide((double)this.stepsRemaining);
    }

    public void tick(long time) {
        long dt = this.lastTime == -1L ? 0L : time - this.lastTime;
        this.lastTime = time;
        if (this.stepsRemaining > 0L) {
            long stepsToTake = Math.min(this.stepsRemaining, dt);
            this.vector.add(this.step.x * (double)stepsToTake, this.step.y * (double)stepsToTake, this.step.z * (double)stepsToTake);
            this.stepsRemaining -= stepsToTake;
            this.vector.x = Math.max(this.bounds.min.x, Math.min(this.bounds.max.x, this.vector.x));
            this.vector.y = Math.max(this.bounds.min.y, Math.min(this.bounds.max.y, this.vector.y));
            this.vector.z = Math.max(this.bounds.min.z, Math.min(this.bounds.max.z, this.vector.z));
        }
    }

    public void apply(Vector3 target) {
        target.add(this.vector);
    }
}

