/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Translation;
import java.util.List;
import mrtjp.projectred.fabrication.editor.tools.WirePlacerTool;
import mrtjp.projectred.fabrication.engine.wires.ICWireTileType;
import mrtjp.projectred.fabrication.gui.ICEditorToolManager;
import mrtjp.projectred.fabrication.gui.ICEditorToolTab;
import mrtjp.projectred.fabrication.gui.TabButtonNode;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchScreen;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.transmission.client.WireModelRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;

public class WirePlacerToolTab
extends ICEditorToolTab {
    private final WirePlacerTool tool;

    public WirePlacerToolTab(ICEditorToolManager manager, WirePlacerTool tool) {
        super(manager, tool);
        this.tool = tool;
        this.construct();
    }

    private void addWireButton(final ICWireTileType type, boolean fullRow) {
        ICEditorToolTab.ButtonController buttonController = new ICEditorToolTab.ButtonController(){

            @Override
            public void getTooltip(List<Component> tooltip) {
                tooltip.add((Component)Component.m_237115_((String)type.tileType.getUnlocalizedName()));
            }

            @Override
            public void onClick() {
                WirePlacerToolTab.this.tool.setWireType(type);
            }

            @Override
            public boolean isSelected() {
                return WirePlacerToolTab.this.tool.getWireType() == type;
            }

            @Override
            public void renderIcon(GuiGraphics graphics, Point absPos, float partialFrame) {
                MultiBufferSource.BufferSource getter = Minecraft.m_91087_().m_91269_().m_110104_();
                CCRenderState ccrs = CCRenderState.instance();
                ccrs.reset();
                ccrs.bind(RenderType.m_110463_(), (MultiBufferSource)getter, graphics.m_280168_());
                ccrs.overlay = OverlayTexture.f_118083_;
                ccrs.brightness = 0xF000F0;
                double scale = 0.625;
                TransformationList t = new TransformationList(new Transformation[]{new Rotation(1.5707963267948701, 1.0, 0.0, 0.0), new Scale(16.0 * scale, -16.0 * scale, 16.0 * scale), new Translation((double)(absPos.x + 8) - scale * 8.0, (double)(absPos.y + 8) - scale * 8.0, 0.0)});
                WireModelRenderer.renderInventory((CCRenderState)ccrs, (int)type.multipartType.getThickness(), (int)(type.multipartType.getItemColour() << 8 | 0xFF), (TextureAtlasSprite)((TextureAtlasSprite)type.multipartType.getTextures().get(0)), (Transformation)t);
                getter.m_109911_();
            }
        };
        if (fullRow) {
            this.addFullRowButton(buttonController);
        } else {
            this.addSingleButton(buttonController);
        }
    }

    private void construct() {
        this.addGroup("projectred_fabrication.tilegroup.redwire");
        this.addWireButton(ICWireTileType.RED_ALLOY, true);
        for (ICWireTileType type : ICWireTileType.INSULATED) {
            this.addWireButton(type, false);
        }
        this.addGroup("projectred_fabrication.tilegroup.bundled");
        this.addWireButton(ICWireTileType.BUNDLED_NEUTRAL, true);
        for (ICWireTileType type : ICWireTileType.BUNDLED_COLOURED) {
            this.addWireButton(type, false);
        }
    }

    @Override
    public TabButtonNode createButtonNode() {
        return new TabButtonNode(this, TabButtonNode.TabSide.LEFT){

            @Override
            public void renderIcon(GuiGraphics graphics, Point mouse, float partialFrame) {
                graphics.m_280163_(ICWorkbenchScreen.BACKGROUND, this.getFrame().x() + 3, this.getFrame().y() + 3, 390.0f, 46.0f, 14, 14, 512, 512);
            }

            @Override
            public void buildTooltip(List<Component> tooltip) {
                tooltip.add((Component)Component.m_237115_((String)"projectred_fabrication.tool.wires"));
            }
        };
    }
}

