/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui.screen;

import codechicken.lib.colour.EnumColour;
import javax.annotation.Nullable;
import mrtjp.fengine.TileCoord;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.gui.ButtonArrayNode;
import mrtjp.projectred.fabrication.gui.PipelineDiagramNode;
import mrtjp.projectred.fabrication.gui.VerticalListNode;
import mrtjp.projectred.fabrication.lithography.LithographyPipeline;
import mrtjp.projectred.fabrication.lithography.ProcessNode;
import mrtjp.projectred.fabrication.lithography.WaferType;
import mrtjp.projectred.fabrication.lithography.YieldCalculator;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Rect;
import mrtjp.projectred.redui.AbstractGuiNode;
import mrtjp.projectred.redui.RedUINode;
import mrtjp.projectred.redui.ScrollBarNode;
import mrtjp.projectred.redui.TextBoxNode;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ICWorkbenchInfoTab
extends AbstractGuiNode {
    public static final ResourceLocation TAB_BACKGROUND = new ResourceLocation("projectred_fabrication", "textures/gui/info_tab.png");
    private final ICWorkbenchEditor editor;
    private final YieldCalculator yieldCalculator = new YieldCalculator();
    @Nullable
    private VerticalListNode listNode;

    public ICWorkbenchInfoTab(ICWorkbenchEditor editor) {
        this.editor = editor;
        this.setSize(304, 222);
        this.initSubNodes();
    }

    private void initSubNodes() {
        this.listNode = new VerticalListNode();
        this.listNode.setPosition(6, 17);
        this.listNode.setSize(280, 198);
        this.addChild((RedUINode)this.listNode);
        NameTextBox nameTextBox = new NameTextBox();
        nameTextBox.setSize(80, 18);
        this.listNode.addTitleRow((Component)Component.m_237115_((String)"projectred_fabrication.ui.blueprint_info"));
        this.listNode.addTextWithNodeRow((Component)Component.m_237115_((String)"projectred_fabrication.ui.blueprint_name"), (RedUINode)nameTextBox);
        this.listNode.addKeyValueRow((Component)Component.m_237115_((String)"projectred_fabrication.ui.blueprint_owner"), () -> Component.m_237113_((String)"//TODO"));
        this.listNode.addKeyValueRow((Component)Component.m_237115_((String)"projectred_fabrication.ui.blueprint_dim"), () -> {
            TileCoord dimensions = this.editor.getTileMap().getDimensions();
            return Component.m_237110_((String)"projectred_fabrication.f.dimensions.tiles", (Object[])new Object[]{dimensions.x, dimensions.z});
        });
        this.listNode.addKeyValueRow((Component)Component.m_237115_((String)"projectred_fabrication.ui.blueprint_layers"), () -> {
            TileCoord dimensions = this.editor.getTileMap().getDimensions();
            return Component.m_237113_((String)String.valueOf(dimensions.y));
        });
        this.listNode.addTitleRow((Component)Component.m_237115_((String)"projectred_fabrication.ui.yield_calculator"));
        ButtonArrayNode pipelineButtonGrid = this.createPipelineButtons();
        pipelineButtonGrid.setGridSize(128, 18);
        this.listNode.addTextWithNodeRow((Component)Component.m_237115_((String)"projectred_fabrication.ui.lithography_pipeline"), (RedUINode)pipelineButtonGrid);
        ButtonArrayNode processNodeButtonGrid = this.createProcessNodeButtons();
        processNodeButtonGrid.setGridSize(128, 18);
        this.listNode.addTextWithNodeRow((Component)Component.m_237115_((String)"projectred_fabrication.ui.process_node"), (RedUINode)processNodeButtonGrid);
        ButtonArrayNode waferTypeButtonGrid = this.createWaferTypeButtons();
        waferTypeButtonGrid.setGridSize(128, 18);
        this.listNode.addTextWithNodeRow((Component)Component.m_237115_((String)"projectred_fabrication.ui.wafer_type"), (RedUINode)waferTypeButtonGrid);
        PipelineDiagramNode diagramNode = new PipelineDiagramNode(this.yieldCalculator);
        this.listNode.addSingleNodeRow((RedUINode)diagramNode);
        ScrollBarNode scrollBarNode = new ScrollBarNode(ScrollBarNode.ScrollAxis.VERTICAL){

            protected void drawSlider(GuiGraphics graphics, Rect sliderFrame) {
                graphics.m_280163_(TAB_BACKGROUND, sliderFrame.x(), sliderFrame.y(), 305.0f, 58.0f, sliderFrame.width(), sliderFrame.height(), 512, 512);
            }

            protected void adjustContent(double scrollPercentage) {
                ICWorkbenchInfoTab.this.listNode.setScrollPercentage(scrollPercentage);
            }
        };
        this.listNode.addKeyValueRow((Component)Component.m_237115_((String)"projectred_fabrication.ui.die_size"), this.yieldCalculator::getDieDimensionsText);
        this.listNode.addKeyValueRow((Component)Component.m_237115_((String)"projectred_fabrication.ui.wafer_size"), this.yieldCalculator::getWaferDimensionsText);
        this.listNode.addKeyValueRow((Component)Component.m_237115_((String)"projectred_fabrication.ui.dies_per_wafer"), this.yieldCalculator::getDieCountDimensionsText);
        this.listNode.addKeyValueRow((Component)Component.m_237115_((String)"projectred_fabrication.ui.single_layer_yield"), this.yieldCalculator::getSingleLayerYieldText);
        this.listNode.addKeyValueRow((Component)Component.m_237115_((String)"projectred_fabrication.ui.yield"), this.yieldCalculator::getYieldText);
        scrollBarNode.setPosition(290, 17);
        scrollBarNode.setSize(8, 198);
        scrollBarNode.setSliderSize(8, 16);
        this.addChild((RedUINode)scrollBarNode);
    }

    public void update() {
        super.update();
        TileCoord dimensions = this.editor.getTileMap().getDimensions();
        this.yieldCalculator.setTileMapSize(dimensions.x, dimensions.z, dimensions.y);
    }

    public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
        graphics.m_280163_(TAB_BACKGROUND, this.getFrame().x(), this.getFrame().y(), 0.0f, 0.0f, this.getFrame().width(), this.getFrame().height(), 512, 512);
        graphics.m_280056_(this.getRoot().getFontRenderer(), this.editor.getIcName(), this.getFrame().x() + 8, this.getFrame().y() + 6, EnumColour.GRAY.argb(), false);
    }

    private ButtonArrayNode createPipelineButtons() {
        ButtonArrayNode.Listener listener = new ButtonArrayNode.Listener(){

            @Override
            public String getButtonText(int index) {
                return LithographyPipeline.values()[index].getUnlocalizedName();
            }

            @Override
            public void onButtonClicked(int index) {
                LithographyPipeline pipeline = LithographyPipeline.values()[index];
                ICWorkbenchInfoTab.this.yieldCalculator.setPipeline(pipeline);
                if (!pipeline.isProcessNodeValid(ICWorkbenchInfoTab.this.yieldCalculator.getProcessNode())) {
                    ICWorkbenchInfoTab.this.yieldCalculator.setProcessNode(ProcessNode.PROCESS_64NM);
                }
                if (!pipeline.isWaferTypeValid(ICWorkbenchInfoTab.this.yieldCalculator.getWaferType())) {
                    ICWorkbenchInfoTab.this.yieldCalculator.setWaferType(WaferType.ROUGH_WAFER);
                }
            }

            @Override
            public boolean isButtonEnabled(int index) {
                return true;
            }

            @Override
            public boolean isButtonSelected(int index) {
                return ICWorkbenchInfoTab.this.yieldCalculator.getPipeline().ordinal() == index;
            }
        };
        return new ButtonArrayNode(listener, 1, LithographyPipeline.values().length, 2);
    }

    private ButtonArrayNode createProcessNodeButtons() {
        ButtonArrayNode.Listener listener = new ButtonArrayNode.Listener(){

            @Override
            public String getButtonText(int index) {
                return ProcessNode.values()[index].getDisplayName();
            }

            @Override
            public void onButtonClicked(int index) {
                ICWorkbenchInfoTab.this.yieldCalculator.setProcessNode(ProcessNode.values()[index]);
            }

            @Override
            public boolean isButtonEnabled(int index) {
                return ICWorkbenchInfoTab.this.yieldCalculator.getPipeline().isProcessNodeValid(ProcessNode.values()[index]);
            }

            @Override
            public boolean isButtonSelected(int index) {
                return ICWorkbenchInfoTab.this.yieldCalculator.getProcessNode().ordinal() == index;
            }
        };
        return new ButtonArrayNode(listener, 1, ProcessNode.values().length, 2);
    }

    private ButtonArrayNode createWaferTypeButtons() {
        ButtonArrayNode.Listener listener = new ButtonArrayNode.Listener(){

            @Override
            public String getButtonText(int index) {
                return WaferType.values()[index].getUnlocalizedName();
            }

            @Override
            public void onButtonClicked(int index) {
                ICWorkbenchInfoTab.this.yieldCalculator.setWaferType(WaferType.values()[index]);
            }

            @Override
            public boolean isButtonEnabled(int index) {
                return ICWorkbenchInfoTab.this.yieldCalculator.getPipeline().isWaferTypeValid(WaferType.values()[index]);
            }

            @Override
            public boolean isButtonSelected(int index) {
                return ICWorkbenchInfoTab.this.yieldCalculator.getWaferType().ordinal() == index;
            }
        };
        return new ButtonArrayNode(listener, 1, WaferType.values().length, 2);
    }

    private class NameTextBox
    extends TextBoxNode {
        public NameTextBox() {
            super(ICWorkbenchInfoTab.this.editor.getIcName());
        }

        public void update() {
            super.update();
            if (!this.getText().equals(ICWorkbenchInfoTab.this.editor.getIcName()) && !this.isEditing()) {
                this.setText(ICWorkbenchInfoTab.this.editor.getIcName());
            }
        }

        protected String getSuggestionString() {
            return ICWorkbenchInfoTab.this.editor.getIcName();
        }

        protected void onTextChanged() {
        }

        protected void onReturnPressed() {
            ICWorkbenchInfoTab.this.editor.sendNewICName(this.getText());
        }
    }
}

