/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui.screen;

import codechicken.lib.colour.EnumColour;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.engine.log.ICCompilerLog;
import mrtjp.projectred.fabrication.gui.SimpleUVTab;
import mrtjp.projectred.fabrication.gui.TabButtonNode;
import mrtjp.projectred.fabrication.gui.TabControllerNode;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchCompileTab;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchEditTab;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchInfoTab;
import mrtjp.projectred.fabrication.init.FabricationBlocks;
import mrtjp.projectred.fabrication.init.FabricationItems;
import mrtjp.projectred.fabrication.tile.ICWorkbenchBlockEntity;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.AbstractGuiNode;
import mrtjp.projectred.redui.ItemStackNode;
import mrtjp.projectred.redui.RedUINode;
import mrtjp.projectred.redui.RedUIScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ICWorkbenchScreen
extends RedUIScreen {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("projectred_fabrication", "textures/gui/ic_workbench.png");
    private final ICWorkbenchBlockEntity tile;
    private final ICWorkbenchEditor editor;
    @Nullable
    private AbstractGuiNode contentNode;
    @Nullable
    private InactiveOverlayNode overlayNode;

    public ICWorkbenchScreen(ICWorkbenchBlockEntity tile) {
        super(304, 222, (Component)Component.m_237113_((String)Objects.requireNonNull(ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)tile.m_58903_())).toString()));
        this.tile = tile;
        this.editor = tile.getEditor();
        this.initSubNodes();
    }

    public static void openGuiOnClient(ICWorkbenchBlockEntity tile) {
        Minecraft.m_91087_().m_91152_((Screen)new ICWorkbenchScreen(tile));
    }

    private void initSubNodes() {
        this.contentNode = new AbstractGuiNode(){};
        this.addChild((RedUINode)this.contentNode);
        ICWorkbenchInfoTab infoTab = new ICWorkbenchInfoTab(this.editor);
        this.contentNode.addChild((RedUINode)infoTab);
        ICWorkbenchEditTab editTab = new ICWorkbenchEditTab(this.editor);
        this.contentNode.addChild((RedUINode)editTab);
        ICWorkbenchCompileTab compileTab = new ICWorkbenchCompileTab(this.editor);
        this.contentNode.addChild((RedUINode)compileTab);
        TabControllerNode tabControllerNode = new TabControllerNode();
        tabControllerNode.setPosition(-19, 4);
        tabControllerNode.setZPosition(0.1);
        this.contentNode.addChild((RedUINode)tabControllerNode);
        tabControllerNode.addButtonForTab(new SimpleUVTab(infoTab, "projectred_fabrication.tab.info", TabButtonNode.TabSide.LEFT, 420, 1));
        tabControllerNode.addButtonForTab(new EditTab(editTab, "projectred_fabrication.tab.edit", TabButtonNode.TabSide.LEFT, 420, 16));
        tabControllerNode.addButtonForTab(new CompileTab(compileTab, "projectred_fabrication.tab.compile", TabButtonNode.TabSide.LEFT, 420, 31));
        tabControllerNode.selectInitialTab(1);
        tabControllerNode.spreadButtonsVertically(1);
        this.overlayNode = new InactiveOverlayNode();
        this.overlayNode.setPosition(this.getFrame().midX() - this.overlayNode.getFrame().width() / 2, this.getFrame().midY() - this.overlayNode.getFrame().height() / 2);
        this.addChild((RedUINode)this.overlayNode);
        this.refreshOverlay();
    }

    public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
        super.drawBack(graphics, mouse, partialFrame);
    }

    public void m_7861_() {
        super.m_7861_();
        this.tile.closeGuiFromClient();
    }

    public void m_7379_() {
        super.m_7379_();
    }

    public void update() {
        this.refreshOverlay();
    }

    public boolean m_6913_() {
        return false;
    }

    public boolean m_7933_(int glfwKeyCode, int glfwScanCode, int glfwFlags) {
        if (super.m_7933_(glfwKeyCode, glfwScanCode, glfwFlags)) {
            return true;
        }
        if (glfwKeyCode == 256) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    private void refreshOverlay() {
        boolean isActive = this.editor.isActive();
        Objects.requireNonNull(this.overlayNode).setHidden(isActive);
        Objects.requireNonNull(this.contentNode).setHidden(!isActive);
    }

    private class EditTab
    extends SimpleUVTab {
        public EditTab(AbstractGuiNode tabBodyNode, String unlocalTabName, TabButtonNode.TabSide side, int u, int v) {
            super(tabBodyNode, unlocalTabName, side, u, v);
        }

        @Override
        protected SimpleUVTab.StatusDot getStatusDot() {
            if (ICWorkbenchScreen.this.editor.getStateMachine().isSimulating()) {
                return SimpleUVTab.StatusDot.GREEN;
            }
            return SimpleUVTab.StatusDot.NONE;
        }

        @Override
        protected void buildTooltip(List<Component> tooltip) {
            super.buildTooltip(tooltip);
            if (ICWorkbenchScreen.this.editor.getStateMachine().isSimulating()) {
                tooltip.add((Component)Component.m_237115_((String)"projectred_fabrication.ui.sim_running").m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
            }
        }
    }

    private class CompileTab
    extends SimpleUVTab {
        public CompileTab(AbstractGuiNode tabBodyNode, String unlocalTabName, TabButtonNode.TabSide side, int u, int v) {
            super(tabBodyNode, unlocalTabName, side, u, v);
        }

        @Override
        protected SimpleUVTab.StatusDot getStatusDot() {
            if (ICWorkbenchScreen.this.editor.getStateMachine().isCompiling()) {
                return SimpleUVTab.StatusDot.GREEN;
            }
            if (ICWorkbenchScreen.this.editor.getStateMachine().didLastCompileFailed()) {
                return SimpleUVTab.StatusDot.RED;
            }
            if (ICWorkbenchScreen.this.editor.getStateMachine().canTriggerCompile()) {
                return SimpleUVTab.StatusDot.YELLOW;
            }
            return SimpleUVTab.StatusDot.NONE;
        }

        @Override
        protected void buildTooltip(List<Component> tooltip) {
            super.buildTooltip(tooltip);
            ICCompilerLog log = ICWorkbenchScreen.this.editor.getStateMachine().getCompilerLog();
            if (ICWorkbenchScreen.this.editor.getStateMachine().canTriggerCompile()) {
                tooltip.add((Component)Component.m_237115_((String)"projectred_fabrication.ui.compile_ready").m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
            }
            if (ICWorkbenchScreen.this.editor.getStateMachine().isCompiling()) {
                tooltip.add((Component)Component.m_237110_((String)"projectred_fabrication.ui.compile_progress", (Object[])new Object[]{log.getCompletedSteps(), log.getTotalSteps()}).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
            }
            if (ICWorkbenchScreen.this.editor.getStateMachine().didLastCompileFailed()) {
                tooltip.add((Component)Component.m_237115_((String)"projectred_fabrication.ui.compile_failed").m_130948_(ICWorkbenchEditor.UNIFORM_RED));
            }
            ICWorkbenchCompileTab.appendProblemsInfo(log, tooltip);
        }
    }

    private static class InactiveOverlayNode
    extends AbstractGuiNode {
        public InactiveOverlayNode() {
            this.setSize(132, 92);
            this.initSubNodes();
        }

        private void initSubNodes() {
            ItemStackNode blueprintNode = new ItemStackNode(new ItemStack((ItemLike)FabricationItems.IC_BLUEPRINT_ITEM.get()));
            blueprintNode.setPosition(58, 24);
            this.addChild((RedUINode)blueprintNode);
            ItemStackNode workbenchNode = new ItemStackNode(new ItemStack((ItemLike)FabricationBlocks.IC_WORKBENCH_BLOCK.get()));
            workbenchNode.setPosition(58, 64);
            this.addChild((RedUINode)workbenchNode);
        }

        public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
            graphics.m_280163_(BACKGROUND, this.getFrame().x(), this.getFrame().y(), 0.0f, 222.0f, this.getFrame().width(), this.getFrame().height(), 512, 512);
            Font fontRenderer = this.getRoot().getFontRenderer();
            MutableComponent text = Component.m_237115_((String)"projectred_fabrication.ui.place_blueprint");
            graphics.m_280614_(fontRenderer, (Component)text, this.getFrame().midX() - fontRenderer.m_92852_((FormattedText)text) / 2, this.getFrame().y() + 6, EnumColour.GRAY.argb(), false);
        }
    }
}

