/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.similarities;

import guideme.internal.shaded.lucene.search.CollectionStatistics;
import guideme.internal.shaded.lucene.search.Explanation;
import guideme.internal.shaded.lucene.search.TermStatistics;
import guideme.internal.shaded.lucene.search.similarities.Similarity;
import guideme.internal.shaded.lucene.util.SmallFloat;
import java.util.ArrayList;

public abstract class TFIDFSimilarity
extends Similarity {
    private static final int[] LENGTH_TABLE = new int[256];

    public TFIDFSimilarity() {
    }

    public TFIDFSimilarity(boolean discountOverlaps) {
        super(discountOverlaps);
    }

    public abstract float tf(float var1);

    public Explanation idfExplain(CollectionStatistics collectionStats, TermStatistics termStats) {
        long df = termStats.docFreq();
        long docCount = collectionStats.docCount();
        float idf = this.idf(df, docCount);
        return Explanation.match((Number)Float.valueOf(idf), "idf(docFreq, docCount)", Explanation.match((Number)df, "docFreq, number of documents containing term", new Explanation[0]), Explanation.match((Number)docCount, "docCount, total number of documents with field", new Explanation[0]));
    }

    public Explanation idfExplain(CollectionStatistics collectionStats, TermStatistics[] termStats) {
        double idf = 0.0;
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        for (TermStatistics stat : termStats) {
            Explanation idfExplain = this.idfExplain(collectionStats, stat);
            subs.add(idfExplain);
            idf += (double)idfExplain.getValue().floatValue();
        }
        return Explanation.match((Number)Float.valueOf((float)idf), "idf(), sum of:", subs);
    }

    public abstract float idf(long var1, long var3);

    public abstract float lengthNorm(int var1);

    @Override
    public final Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        Explanation idf = termStats.length == 1 ? this.idfExplain(collectionStats, termStats[0]) : this.idfExplain(collectionStats, termStats);
        float[] normTable = new float[256];
        for (int i = 1; i < 256; ++i) {
            float norm;
            normTable[i] = norm = this.lengthNorm(LENGTH_TABLE[i]);
        }
        normTable[0] = 1.0f / normTable[255];
        return new TFIDFScorer(boost, idf, normTable);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            TFIDFSimilarity.LENGTH_TABLE[i] = SmallFloat.byte4ToInt((byte)i);
        }
    }

    class TFIDFScorer
    extends Similarity.SimScorer {
        private final Explanation idf;
        private final float boost;
        private final float queryWeight;
        final float[] normTable;

        public TFIDFScorer(float boost, Explanation idf, float[] normTable) {
            this.idf = idf;
            this.boost = boost;
            this.queryWeight = boost * idf.getValue().floatValue();
            this.normTable = normTable;
        }

        @Override
        public float score(float freq, long norm) {
            float raw = TFIDFSimilarity.this.tf(freq) * this.queryWeight;
            float normValue = this.normTable[(int)(norm & 0xFFL)];
            return raw * normValue;
        }

        @Override
        public Explanation explain(Explanation freq, long norm) {
            return this.explainScore(freq, norm, this.normTable);
        }

        private Explanation explainScore(Explanation freq, long encodedNorm, float[] normTable) {
            ArrayList<Explanation> subs = new ArrayList<Explanation>();
            if (this.boost != 1.0f) {
                subs.add(Explanation.match((Number)Float.valueOf(this.boost), "boost", new Explanation[0]));
            }
            subs.add(this.idf);
            Explanation tf = Explanation.match((Number)Float.valueOf(TFIDFSimilarity.this.tf(freq.getValue().floatValue())), "tf(freq=" + freq.getValue() + "), with freq of:", freq);
            subs.add(tf);
            float norm = normTable[(int)(encodedNorm & 0xFFL)];
            Explanation fieldNorm = Explanation.match((Number)Float.valueOf(norm), "fieldNorm", new Explanation[0]);
            subs.add(fieldNorm);
            return Explanation.match((Number)Float.valueOf(this.queryWeight * tf.getValue().floatValue() * norm), "score(freq=" + freq.getValue() + "), product of:", subs);
        }
    }
}

