/*
 * Decompiled with CFR 0.152.
 */
package guideme.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import guideme.color.ColorValue;
import guideme.color.ConstantColor;
import guideme.color.LightDarkMode;
import guideme.color.MutableColor;
import guideme.document.LytRect;
import guideme.internal.util.FluidBlitter;
import guideme.layout.MinecraftFontMetrics;
import guideme.render.GuiSprite;
import guideme.render.GuidePageTexture;
import guideme.render.PanelBlitter;
import guideme.render.SpriteLayer;
import guideme.style.ResolvedTextStyle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public interface RenderContext {
    public LightDarkMode lightDarkMode();

    default public boolean isDarkMode() {
        return this.lightDarkMode() == LightDarkMode.DARK_MODE;
    }

    public GuiGraphics guiGraphics();

    default public PoseStack poseStack() {
        return this.guiGraphics().m_280168_();
    }

    public LytRect viewport();

    default public boolean intersectsViewport(LytRect bounds) {
        return bounds.intersects(this.viewport());
    }

    public int resolveColor(ColorValue var1);

    public void fillRect(LytRect var1, ColorValue var2, ColorValue var3, ColorValue var4, ColorValue var5);

    default public void drawIcon(int x, int y, GuiSprite guiSprite) {
        this.drawIcon(x, y, guiSprite, (ColorValue)ConstantColor.WHITE);
    }

    default public void drawIcon(int x, int y, GuiSprite guiSprite, ColorValue color) {
        this.drawIcon(x, y, guiSprite.atlasSprite(this.lightDarkMode()), color);
    }

    default public void drawIcon(int x, int y, TextureAtlasSprite sprite, ColorValue color) {
        SpriteContents contents = sprite.m_245424_();
        this.fillIcon(x, y, contents.m_246492_(), contents.m_245330_(), sprite, color);
    }

    default public void fillIcon(LytRect bounds, GuiSprite guiSprite) {
        this.fillIcon(bounds.x(), bounds.y(), bounds.width(), bounds.height(), guiSprite);
    }

    default public void fillIcon(LytRect bounds, GuiSprite guiSprite, ColorValue color) {
        this.fillIcon(bounds.x(), bounds.y(), bounds.width(), bounds.height(), guiSprite, color);
    }

    default public void fillIcon(int x, int y, int width, int height, GuiSprite guiSprite) {
        this.fillIcon(x, y, width, height, guiSprite, (ColorValue)ConstantColor.WHITE);
    }

    default public void fillIcon(int x, int y, int width, int height, GuiSprite guiSprite, ColorValue color) {
        this.fillIcon(x, y, width, height, guiSprite.atlasSprite(this.lightDarkMode()), color);
    }

    default public void fillIcon(int x, int y, int width, int height, TextureAtlasSprite sprite, ColorValue color) {
        SpriteLayer spriteLayer = new SpriteLayer();
        spriteLayer.fillSprite(sprite.m_245424_().m_246162_(), 0.0f, 0.0f, 0.0f, width, height, this.resolveColor(color));
        spriteLayer.render(this.poseStack(), x, y, 0);
    }

    default public void fillTexturedRect(LytRect rect, AbstractTexture texture, ColorValue topLeft, ColorValue topRight, ColorValue bottomRight, ColorValue bottomLeft) {
        this.fillTexturedRect(rect, texture, topLeft, topRight, bottomRight, bottomLeft, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public void fillTexturedRect(LytRect var1, AbstractTexture var2, ColorValue var3, ColorValue var4, ColorValue var5, ColorValue var6, float var7, float var8, float var9, float var10);

    default public void fillTexturedRect(LytRect rect, GuidePageTexture texture) {
        this.fillTexturedRect(rect, texture.use(), (ColorValue)ConstantColor.WHITE);
    }

    default public void fillTexturedRect(LytRect rect, AbstractTexture texture) {
        this.fillTexturedRect(rect, texture, (ColorValue)ConstantColor.WHITE);
    }

    default public void fillTexturedRect(LytRect rect, AbstractTexture texture, ColorValue color) {
        this.fillTexturedRect(rect, texture, color, color, color, color);
    }

    default public void fillTexturedRect(LytRect rect, GuidePageTexture texture, ColorValue color) {
        this.fillTexturedRect(rect, texture.use(), color, color, color, color);
    }

    default public void fillTexturedRect(LytRect rect, TextureAtlasSprite sprite, ColorValue color) {
        AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(sprite.m_247685_());
        this.fillTexturedRect(rect, texture, color, color, color, color, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_());
    }

    default public void fillTexturedRect(LytRect rect, ResourceLocation textureId) {
        this.fillTexturedRect(rect, textureId, (ColorValue)ConstantColor.WHITE);
    }

    default public void fillTexturedRect(LytRect rect, ResourceLocation textureId, ColorValue color) {
        AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(textureId);
        this.fillTexturedRect(rect, texture, color);
    }

    public void fillTriangle(Vec2 var1, Vec2 var2, Vec2 var3, ColorValue var4);

    default public Font font() {
        return Minecraft.m_91087_().f_91062_;
    }

    default public float getAdvance(int codePoint, ResolvedTextStyle style) {
        return this.font().m_92863_(style.font()).m_243128_(codePoint, false).m_83827_(style.bold());
    }

    default public float getWidth(String text, ResolvedTextStyle style) {
        return (float)text.codePoints().mapToDouble(cp -> this.getAdvance(cp, style)).sum();
    }

    default public void renderTextCenteredIn(String text, ResolvedTextStyle style, LytRect rect) {
        StringSplitter splitter = new StringSplitter((i, ignored) -> this.getAdvance(i, style));
        MinecraftFontMetrics fontMetrics = new MinecraftFontMetrics(this.font());
        List splitLines = splitter.m_92432_(text, (int)((float)(rect.width() - 10) / style.fontScale()), Style.f_131099_);
        int lineHeight = fontMetrics.getLineHeight(style);
        int overallHeight = splitLines.size() * lineHeight;
        int overallWidth = (int)(splitLines.stream().mapToDouble(arg_0 -> ((StringSplitter)splitter).m_92384_(arg_0)).max().orElse(0.0) * (double)style.fontScale());
        LytRect textRect = new LytRect(0, 0, overallWidth, overallHeight);
        textRect = textRect.centerIn(rect);
        int y = textRect.y();
        for (FormattedText line : splitLines) {
            float x = (float)textRect.x() + ((float)textRect.width() - splitter.m_92384_(line) * style.fontScale()) / 2.0f;
            this.renderText(line.getString(), style, x, y);
            y += lineHeight;
        }
    }

    default public void renderText(String text, ResolvedTextStyle style, float x, float y) {
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        this.renderTextInBatch(text, style, x, y, (MultiBufferSource)bufferSource);
        bufferSource.m_109911_();
    }

    default public void renderTextInBatch(String text, ResolvedTextStyle style, float x, float y, MultiBufferSource buffers) {
        Style effectiveStyle = Style.f_131099_.m_131136_(Boolean.valueOf(style.bold())).m_131155_(Boolean.valueOf(style.italic())).m_131162_(Boolean.valueOf(style.underlined())).m_178522_(Boolean.valueOf(style.strikethrough())).m_131150_(style.font());
        Matrix4f matrix = this.poseStack().m_85850_().m_252922_();
        if (style.fontScale() != 1.0f) {
            matrix = new Matrix4f((Matrix4fc)matrix);
            matrix.scale(style.fontScale(), style.fontScale(), 1.0f);
            matrix.translate((Vector3fc)new Vector3f(x / style.fontScale(), y / style.fontScale(), 0.0f));
            x = 0.0f;
            y = 0.0f;
        }
        this.font().m_272077_((Component)Component.m_237113_((String)text).m_130948_(effectiveStyle), x, y, this.resolveColor(style.color()), style.dropShadow(), matrix, buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    default public void fillRect(int x, int y, int width, int height, ColorValue color) {
        this.fillRect(new LytRect(x, y, width, height), color);
    }

    default public void fillRect(LytRect rect, ColorValue color) {
        this.fillRect(rect, color, color, color, color);
    }

    default public void fillGradientVertical(LytRect rect, ColorValue top, ColorValue bottom) {
        this.fillRect(rect, top, top, bottom, bottom);
    }

    default public void fillGradientVertical(int x, int y, int width, int height, ColorValue top, ColorValue bottom) {
        this.fillGradientVertical(new LytRect(x, y, width, height), top, bottom);
    }

    default public void fillGradientHorizontal(LytRect rect, ColorValue left, ColorValue right) {
        this.fillRect(rect, left, right, right, left);
    }

    default public void fillGradientHorizontal(int x, int y, int width, int height, ColorValue left, ColorValue right) {
        this.fillGradientHorizontal(new LytRect(x, y, width, height), left, right);
    }

    default public MultiBufferSource.BufferSource beginBatch() {
        return MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
    }

    default public void endBatch(MultiBufferSource.BufferSource batch) {
        batch.m_109911_();
    }

    default public void renderItem(ItemStack stack, int x, int y, float width, float height) {
        this.renderItem(stack, x, y, 0, width, height);
    }

    default public void renderFluid(Fluid fluid, int x, int y, int z, int width, int height) {
        FluidBlitter.create(new FluidStack(fluid, 1)).dest(x, y, width, height).zOffset(z).blit(this.guiGraphics());
    }

    default public void renderFluid(FluidStack stack, int x, int y, int z, int width, int height) {
        FluidBlitter.create(stack).dest(x, y, width, height).blit(this.guiGraphics());
    }

    public void renderItem(ItemStack var1, int var2, int var3, int var4, float var5, float var6);

    default public void renderPanel(LytRect bounds) {
        PanelBlitter panelBlitter = new PanelBlitter(this.lightDarkMode());
        panelBlitter.addBounds(0, 0, bounds.width(), bounds.height());
        panelBlitter.blit(this.guiGraphics(), bounds.x(), bounds.y());
    }

    default public void pushScissor(LytRect bounds) {
        Vector3f dest = new Vector3f();
        Matrix4f pose = this.poseStack().m_85850_().m_252922_();
        pose.transformPosition((float)bounds.x(), (float)bounds.y(), 0.0f, dest);
        float left = dest.x;
        float top = dest.y;
        pose.transformPosition((float)bounds.right(), (float)bounds.bottom(), 0.0f, dest);
        this.guiGraphics().m_280262_();
        this.guiGraphics().m_280588_((int)left, (int)top, (int)dest.x, (int)dest.y);
    }

    default public void popScissor() {
        this.guiGraphics().m_280262_();
        this.guiGraphics().m_280618_();
    }

    default public MutableColor mutableColor(ColorValue symbolicColor) {
        return MutableColor.of(symbolicColor, this.lightDarkMode());
    }
}

