/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.internal.network.Network;
import it.zerono.mods.zerocore.lib.data.nbt.IConditionallySyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.ContainerFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotIndexSet;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotTemplate;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.type.SlotGeneric;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.type.SlotType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import org.jetbrains.annotations.Nullable;

public class ModContainer
extends AbstractContainerMenu
implements IContainerData {
    public static final String INVENTORYNAME_PLAYER_INVENTORY = "playerinventory";
    public static final String INVENTORY_CONTAINER = "container";
    public static final String SLOTGROUPNAME_PLAYER_INVENTORY = "playerinventory_main";
    public static final String SLOTGROUPNAME_PLAYER_HOTBAR = "playerinventory_hotbar";
    private final ContainerFactory _factory;
    private final Map<String, IItemHandler> _registeredInventories;
    private final Map<String, List<Slot>> _inventorySlotsGroups;
    private final Player _player;
    private final int _ticksBetweenUpdates;
    private int _ticksSinceLastUpdate;
    private IEvent<Runnable> _dataUpdateEvent;
    private IConditionallySyncableEntity _syncableEntity;
    private ObjectList<IContainerData> _dataToSync;

    public ModContainer(int ticksBetweenUpdates, ContainerFactory factory, MenuType<?> type, int windowId, Inventory playerInventory) {
        super(type, windowId);
        this._factory = factory;
        this._registeredInventories = Maps.newHashMap();
        this._inventorySlotsGroups = Maps.newHashMap();
        this._player = playerInventory.f_35978_;
        this._ticksBetweenUpdates = ticksBetweenUpdates;
        this._ticksSinceLastUpdate = 0;
    }

    public static ModContainer empty(MenuType<?> type, int windowId, Inventory playerInventory) {
        return new ModContainer(200, ContainerFactory.EMPTY, (MenuType)type, windowId, playerInventory){

            public void m_182406_(int slotID, int p_182408_, ItemStack stack) {
            }
        };
    }

    public Optional<IItemHandler> getInventory(String name) {
        return Optional.ofNullable(this._registeredInventories.get(name));
    }

    public void addInventory(String name, IItemHandler inventory) {
        this._registeredInventories.put(name, inventory);
    }

    public void addInventory(String name, Container inventory) {
        this.addInventory(name, (IItemHandler)new InvWrapper(inventory));
    }

    public void addInventory(String name, Inventory inventory) {
        this.addInventory(name, (IItemHandler)new PlayerInvWrapper(inventory));
    }

    public void addBindableData(IBindableData<?> data) {
        Preconditions.checkArgument((boolean)(data instanceof IContainerData), (Object)"Data must implement IContainerData too.");
        this.addContainerData((IContainerData)((Object)data));
    }

    @Deprecated
    public void addContainerData(IContainerData data) {
        if (null == this._dataToSync) {
            this._dataToSync = new ObjectArrayList(4);
        }
        if (Short.MAX_VALUE == this._dataToSync.size()) {
            throw new IllegalStateException("Too many container data object added!");
        }
        this._dataToSync.add((Object)data);
    }

    public Runnable subscribeContainerDataUpdate(Runnable handler) {
        if (null == this._dataUpdateEvent) {
            this._dataUpdateEvent = new Event<Runnable>();
        }
        return this._dataUpdateEvent.subscribe(handler);
    }

    public void unsubscribeContainerDataUpdate(Runnable handler) {
        if (null != this._dataUpdateEvent) {
            this._dataUpdateEvent.unsubscribe(handler);
        }
    }

    public void createSlots() {
        for (SlotFactory slotFactory : this._factory.getSlots()) {
            String inventoryName = slotFactory.getInventoryName();
            this.getInventory(inventoryName).ifPresent(inventory -> this.addSlotFor(slotFactory, (IItemHandler)inventory));
        }
    }

    public List<Slot> getInventorySlotsGroup(String inventoryGroupName) {
        if (this._inventorySlotsGroups.containsKey(inventoryGroupName)) {
            return Collections.unmodifiableList(this._inventorySlotsGroups.get(inventoryGroupName));
        }
        return Collections.emptyList();
    }

    public PlayerInventoryUsage getPlayPlayerInventoryUsage() {
        return this._factory.getPlayPlayerInventoryUsage();
    }

    public void syncFrom(@Nullable IConditionallySyncableEntity entity) {
        this._syncableEntity = entity;
    }

    public void onContainerDataSync(CompoundTag data) {
        if (null != this._syncableEntity && this._syncableEntity.getSyncableEntityId().equals((Object)new ResourceLocation(data.m_128461_("id")))) {
            this._syncableEntity.syncDataFrom(data.m_128469_("payload"), ISyncableEntity.SyncReason.NetworkUpdate);
        }
    }

    public Player getPlayer() {
        return this._player;
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        return buffer -> {
            buffer.writeInt(this.f_38840_);
            if (null != this._dataToSync && !this._dataToSync.isEmpty()) {
                for (int idx = 0; idx < this._dataToSync.size(); ++idx) {
                    NonNullConsumer<FriendlyByteBuf> writer = ((IContainerData)this._dataToSync.get(idx)).getContainerDataWriter();
                    if (null == writer) continue;
                    buffer.writeShort(idx);
                    writer.accept(buffer);
                }
            }
            buffer.writeShort(-1);
        };
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        if (this.f_38840_ == dataSource.readInt() && null != this._dataToSync && !this._dataToSync.isEmpty()) {
            short idx;
            while (-1 != (idx = dataSource.readShort())) {
                ((IContainerData)this._dataToSync.get((int)idx)).readContainerData(dataSource);
            }
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    protected boolean m_38903_(ItemStack sourceStack, int startIndex, int endIndex, boolean reverseDirection) {
        Slot targetSlot;
        int targetSlotIndex;
        if (sourceStack.m_41619_() || !this._factory.isIndexValid(startIndex) || !this._factory.isIndexValid(endIndex - 1)) {
            return false;
        }
        int targetSlotIndexModifier = reverseDirection ? -1 : 1;
        int n = targetSlotIndex = reverseDirection ? endIndex - 1 : startIndex;
        if (sourceStack.m_41753_()) {
            while (sourceStack.m_41613_() > 0 && (!reverseDirection && targetSlotIndex < endIndex || reverseDirection && targetSlotIndex >= startIndex)) {
                targetSlot = this.m_38853_(targetSlotIndex);
                ItemStack targetItemStack = targetSlot.m_7993_();
                if (!targetItemStack.m_41619_() && ItemHelper.stackMatch(targetItemStack, sourceStack, ItemHelper.MatchOption.MATCH_EXISTING_STACK) && targetSlot.m_5857_(sourceStack)) {
                    int maxStackSize;
                    int mergedSize = targetItemStack.m_41613_() + sourceStack.m_41613_();
                    if (mergedSize <= (maxStackSize = Math.min(targetSlot.m_6641_(), sourceStack.m_41741_()))) {
                        ItemHelper.stackSetSize(sourceStack, 0);
                        ItemHelper.stackSetSize(targetItemStack, mergedSize);
                        targetSlot.m_6654_();
                        return true;
                    }
                    if (targetItemStack.m_41613_() < maxStackSize) {
                        sourceStack.m_41769_(-(maxStackSize - targetItemStack.m_41613_()));
                        ItemHelper.stackSetSize(targetItemStack, maxStackSize);
                        targetSlot.m_6654_();
                        return true;
                    }
                }
                targetSlotIndex += targetSlotIndexModifier;
            }
        }
        if (sourceStack.m_41613_() > 0) {
            int n2 = targetSlotIndex = reverseDirection ? endIndex - 1 : startIndex;
            while (!reverseDirection && targetSlotIndex < endIndex || reverseDirection && targetSlotIndex >= startIndex) {
                targetSlot = this.m_38853_(targetSlotIndex);
                if (!targetSlot.m_6657_() && targetSlot.m_5857_(sourceStack)) {
                    targetSlot.m_5852_(ItemHelper.stackFrom(sourceStack));
                    targetSlot.m_6654_();
                    ItemHelper.stackSetSize(sourceStack, 0);
                    return true;
                }
                targetSlotIndex += targetSlotIndexModifier;
            }
        }
        return false;
    }

    public void m_150399_(int clickedSlotIndex, int dragType, ClickType clickTypeIn, Player player) {
        Slot slot;
        if (this._factory.isSlotOfType(clickedSlotIndex, SlotType.GhostInput) && (slot = this.m_38853_(clickedSlotIndex)).m_6657_()) {
            slot.m_5852_(ItemStack.f_41583_);
        }
        SlotType slotType = this._factory.getSlotType(clickedSlotIndex);
        switch (slotType) {
            case GhostOutput: 
            case Static: 
            case Unknown: {
                break;
            }
            default: {
                super.m_150399_(clickedSlotIndex, dragType, clickTypeIn, player);
            }
        }
    }

    public ItemStack m_7648_(Player player, int clickedSlotIndex) {
        Optional<SlotTemplate> clickedTemplate = this._factory.getSlotTemplate(clickedSlotIndex);
        if (!clickedTemplate.isPresent()) {
            Log.LOGGER.warn("Unknown slot clicked in a ModContainer at index " + clickedSlotIndex);
            return ItemStack.f_41583_;
        }
        SlotGeneric clickedSlot = (SlotGeneric)this.m_38853_(clickedSlotIndex);
        if (!clickedSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack clickedStack = clickedSlot.m_7993_();
        ItemStack resultStack = ItemHelper.stackFrom(clickedStack);
        switch (clickedTemplate.map(SlotTemplate::getType).orElse(SlotType.Unknown)) {
            case Static: 
            case Input: 
            case Output: {
                if (!(this.addStackToTargetSlots(clickedStack, SlotType.Special, false) || this.addStackToTargetSlots(clickedStack, SlotType.PlayerInventory, true) || this.addStackToTargetSlots(clickedStack, SlotType.PlayerHotbar, false))) {
                    return ItemStack.f_41583_;
                }
                clickedSlot.m_40234_(clickedStack, resultStack);
                break;
            }
            case GhostOutput: 
            case GhostInput: {
                return ItemStack.f_41583_;
            }
            case PlayerInventory: {
                if (this.addStackToTargetSlots(clickedStack, SlotType.Special, false) || this.addStackToTargetSlots(clickedStack, SlotType.Input, false) || this.addStackToTargetSlots(clickedStack, SlotType.PlayerHotbar, false)) break;
                return ItemStack.f_41583_;
            }
            case PlayerHotbar: {
                if (this.addStackToTargetSlots(clickedStack, SlotType.Special, false) || this.addStackToTargetSlots(clickedStack, SlotType.Input, false) || this.addStackToTargetSlots(clickedStack, SlotType.PlayerInventory, false)) break;
                return ItemStack.f_41583_;
            }
            case Special: {
                if (!this.addStackToTargetSlots(clickedStack, SlotType.PlayerInventory, true) && !this.addStackToTargetSlots(clickedStack, SlotType.PlayerHotbar, false)) {
                    return ItemStack.f_41583_;
                }
                clickedSlot.m_40234_(clickedStack, resultStack);
            }
        }
        if (clickedStack.m_41613_() == 0) {
            clickedSlot.m_5852_(ItemStack.f_41583_);
        } else {
            clickedSlot.m_6654_();
        }
        if (clickedStack.m_41613_() == resultStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        clickedSlot.m_142406_(player, clickedStack);
        return resultStack;
    }

    protected Slot m_38897_(Slot slotIn) {
        if (!(slotIn instanceof SlotGeneric)) {
            throw new RuntimeException("Do not call Container.addSlot() directly! Use the ContainerFactory to add your slots to a ModContainer");
        }
        return super.m_38897_(slotIn);
    }

    public void m_38946_() {
        super.m_38946_();
        if (this._player instanceof ServerPlayer) {
            if (null != this._syncableEntity && this._syncableEntity.shouldSyncEntity()) {
                CompoundTag envelope = new CompoundTag();
                envelope.m_128359_("id", this._syncableEntity.getSyncableEntityId().toString());
                envelope.m_128365_("payload", (Tag)this._syncableEntity.syncDataTo(new CompoundTag(), ISyncableEntity.SyncReason.NetworkUpdate));
                Network.sendServerContainerDataSync((ServerPlayer)this._player, envelope);
            }
            if (null != this._dataToSync && !this._dataToSync.isEmpty()) {
                ++this._ticksSinceLastUpdate;
                if (this._ticksSinceLastUpdate >= this._ticksBetweenUpdates) {
                    this._ticksSinceLastUpdate = 0;
                    Network.sendServerContainerData((ServerPlayer)this._player, this);
                }
            }
        }
    }

    private void addSlotFor(SlotFactory slotFactory, IItemHandler inventory) {
        Slot slot = slotFactory.createSlot(inventory);
        super.m_38897_(slot);
        this.addSlotToGroup(slotFactory.getInventoryName(), slot);
        switch (slotFactory.getTemplate().getType()) {
            case PlayerInventory: {
                this.addSlotToGroup(SLOTGROUPNAME_PLAYER_INVENTORY, slot);
                break;
            }
            case PlayerHotbar: {
                this.addSlotToGroup(SLOTGROUPNAME_PLAYER_HOTBAR, slot);
            }
        }
    }

    private void addSlotToGroup(String inventoryName, Slot slot) {
        this._inventorySlotsGroups.computeIfAbsent(inventoryName, name -> Lists.newArrayList()).add(slot);
    }

    private boolean addStackToTargetSlots(ItemStack stack, SlotType targetSlotsType, boolean reverseDirection) {
        List<SlotIndexSet> targetIndices = this._factory.getIndicesForType(targetSlotsType);
        if (targetIndices.isEmpty()) {
            return false;
        }
        for (SlotIndexSet indexSet : targetIndices) {
            for (Range<Integer> range : indexSet.asRanges()) {
                if (!this.m_38903_(stack, (Integer)range.lowerEndpoint(), (Integer)range.upperEndpoint(), reverseDirection)) continue;
                return true;
            }
        }
        return false;
    }
}

