/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock;

import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IActivableMachine;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockRegistry;
import it.zerono.mods.zerocore.lib.multiblock.registry.MultiblockRegistry;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.LogicalSide;

public abstract class AbstractMultiblockPart<Controller extends IMultiblockController<Controller>>
extends AbstractModBlockEntity
implements IMultiblockPart<Controller>,
IDebuggable {
    private Runnable onDataUpdateHandler;
    private Controller _controller = null;
    private boolean _unvisited = true;
    private boolean _saveMultiblockData = false;
    private CompoundTag _cachedMultiblockData = null;
    private final long _positionHash = this.f_58858_.m_121878_();

    public AbstractMultiblockPart(BlockEntityType<?> type, BlockPos position, BlockState blockState) {
        super(type, position, blockState);
    }

    public Level getPartWorldOrFail() {
        Level world = this.m_58904_();
        if (null == world) {
            throw new IllegalStateException("Found a multiblock part without a world!");
        }
        return world;
    }

    @Override
    public boolean isConnected() {
        return null != this._controller;
    }

    @Override
    public boolean isMachineAssembled() {
        return this.isConnected() && this._controller.isAssembled();
    }

    @Override
    public boolean isMachineDisassembled() {
        return this.isConnected() && this._controller.isDisassembled();
    }

    @Override
    public boolean isMachinePaused() {
        return this.isConnected() && this._controller.isPaused();
    }

    @Override
    public Optional<Controller> getMultiblockController() {
        return Optional.ofNullable(this._controller);
    }

    @Override
    public void executeOnController(Consumer<Controller> code) {
        if (null != this._controller) {
            code.accept(this._controller);
        }
    }

    @Override
    public <R> R evalOnController(Function<Controller, R> code, R defaultValue) {
        return null != this._controller ? code.apply(this._controller) : defaultValue;
    }

    @Override
    public <R> R evalOnControllerOrGet(Function<Controller, R> code, Supplier<R> defaultValue) {
        return null != this._controller ? code.apply(this._controller) : defaultValue.get();
    }

    @Override
    public boolean testOnController(Predicate<Controller> test) {
        return null != this._controller && test.test(this._controller);
    }

    @Override
    public Optional<Level> getPartWorld() {
        return Optional.ofNullable(this.m_58904_());
    }

    @Override
    public <T> T mapPartWorld(Function<Level, T> mapper, T defaultValue) {
        Level world = this.m_58904_();
        return null != world ? mapper.apply(world) : defaultValue;
    }

    @Override
    public void forPartWorld(Consumer<Level> consumer) {
        Level world = this.m_58904_();
        if (null != world) {
            consumer.accept(world);
        }
    }

    @Override
    public BlockPos getWorldPosition() {
        return this.m_58899_();
    }

    @Override
    public long getWorldPositionHash() {
        return this._positionHash;
    }

    @Override
    public boolean isPartInvalid() {
        return this.m_58901_();
    }

    @Override
    public void onAttached(Controller newController) {
        this._controller = newController;
    }

    @Override
    public void onDetached(Controller oldController) {
        this._controller = null;
    }

    @Override
    public void onOrphaned(Controller controller, int oldSize, int newSize) {
        this.m_6596_();
    }

    @Override
    public void onAssimilated(Controller newController) {
        assert (this._controller != newController);
        this._controller = newController;
    }

    @Override
    public void setVisited() {
        this._unvisited = false;
    }

    @Override
    public void setUnvisited() {
        this._unvisited = true;
    }

    @Override
    public boolean isVisited() {
        return !this._unvisited;
    }

    @Override
    public boolean isNotVisited() {
        return this._unvisited;
    }

    @Override
    public void becomeMultiblockSaveDelegate() {
        this._saveMultiblockData = true;
    }

    @Override
    public void forfeitMultiblockSaveDelegate() {
        this._saveMultiblockData = false;
    }

    @Override
    public boolean isMultiblockSaveDelegate() {
        return this._saveMultiblockData;
    }

    @Override
    public List<IMultiblockPart<Controller>> getNeighboringParts() {
        BlockPos[] positions;
        Level world = this.m_58904_();
        if (null == world) {
            return Collections.emptyList();
        }
        ReferenceArrayList parts = new ReferenceArrayList(6);
        for (BlockPos position : positions = WorldHelper.getNeighboringPositionsList(this.getWorldPosition(), new BlockPos[6])) {
            BlockEntity te = WorldHelper.getLoadedTile(world, position);
            if (!(te instanceof IMultiblockPart)) continue;
            parts.add((IMultiblockPart)te);
        }
        return parts;
    }

    @Override
    public Set<Controller> attachToNeighbors(Function<IMultiblockPart<Controller>, Set<Controller>> controllersLookup) {
        Set<Controller> foundControllers = controllersLookup.apply(this);
        switch (foundControllers.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                this._controller = (IMultiblockController)foundControllers.iterator().next();
                this._controller.attachPart(this);
                return foundControllers;
            }
        }
        ReferenceArraySet candidateControllers = new ReferenceArraySet(6);
        IMultiblockController bestController = null;
        for (IMultiblockController controller : foundControllers) {
            if (null == bestController || !candidateControllers.contains(controller) && controller.shouldConsumeController(bestController)) {
                bestController = controller;
            }
            candidateControllers.add(controller);
        }
        if (null != bestController) {
            this._controller = bestController;
            bestController.attachPart(this);
        }
        return candidateControllers;
    }

    @Override
    public void assertDetached() {
        if (null != this._controller) {
            BlockPos coord = this.getWorldPosition();
            Log.LOGGER.info(Log.MULTIBLOCK, "[assert] Part @ ({}, {}, {}) should be detached already, but detected that it was not. This is not a fatal error, and will be repaired, but is unusual.", (Object)coord.m_123341_(), (Object)coord.m_123342_(), (Object)coord.m_123343_());
            this._controller = null;
        }
    }

    @Override
    public boolean hasMultiblockSaveData() {
        return null != this._cachedMultiblockData;
    }

    @Override
    public Optional<CompoundTag> getMultiblockSaveData() {
        return Optional.ofNullable(this._cachedMultiblockData);
    }

    @Override
    public <T> T mapMultiblockSaveData(Function<CompoundTag, T> mapper, T defaultValue) {
        return null != this._cachedMultiblockData ? mapper.apply(this._cachedMultiblockData) : defaultValue;
    }

    @Override
    public void forMultiblockSaveData(Consumer<CompoundTag> consumer) {
        if (null != this._cachedMultiblockData) {
            consumer.accept(this._cachedMultiblockData);
        }
    }

    @Override
    public void onMultiblockDataAssimilated() {
        this._cachedMultiblockData = null;
    }

    @Override
    public void listenForControllerDataUpdates() {
        this.onDataUpdateHandler = this.getMultiblockController().map(controller -> controller.listenForDataUpdate(() -> this.onDataUpdate())).orElse(null);
    }

    public void unlistenForControllerDataUpdates() {
        if (null != this.onDataUpdateHandler) {
            this.getMultiblockController().ifPresent(controller -> controller.unlistenForDataUpdate(this.onDataUpdateHandler));
            this.onDataUpdateHandler = null;
        }
    }

    @Override
    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        if (data.m_128441_("multiblockData")) {
            CompoundTag multiblockData = data.m_128469_("multiblockData");
            switch (syncReason) {
                case FullSync: {
                    this._cachedMultiblockData = multiblockData;
                    break;
                }
                case NetworkUpdate: {
                    CodeHelper.optionalIfPresentOrElse(this.getMultiblockController(), c -> c.syncFromSaveDelegate(multiblockData, syncReason), () -> {
                        this._cachedMultiblockData = multiblockData;
                    });
                }
            }
        }
    }

    @Override
    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        if (this.isMultiblockSaveDelegate()) {
            this.getMultiblockController().ifPresent(c -> data.m_128365_("multiblockData", (Tag)c.syncDataTo(new CompoundTag(), syncReason)));
        }
        return data;
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        CodeHelper.optionalIfPresentOrElse(this.getMultiblockController(), controller -> this.getControllerDebugMessages(side, controller, messages), () -> messages.addUnlocalized("Part not attached to a controller"));
    }

    private void getControllerDebugMessages(LogicalSide side, Controller controller, IDebugMessages messages) {
        messages.addUnlocalized("Multiblock controller class: %1$s", controller.getClass().getSimpleName());
        messages.addUnlocalized("Attached parts: %1$d; Assembled: %2$s", controller.getPartsCount(), controller.isAssembled());
        controller.getReferenceCoord().ifPresent(position -> messages.addUnlocalized("Reference coordinates %s", position.toString()));
        messages.addUnlocalized(controller.getBoundingBox().toString());
        if (controller instanceof IActivableMachine) {
            messages.addUnlocalized("Active: %1$s", ((IActivableMachine)controller).isMachineActive());
        }
        controller.getLastError().ifPresent(error -> messages.add(side, (IDebuggable)error, "Last validation error: "));
        if (controller instanceof IDebuggable) {
            ((IDebuggable)controller).getDebugMessages(side, messages);
        }
    }

    public void m_6339_() {
        super.m_6339_();
        this.getRegistry().onPartAdded(this);
    }

    public void m_7651_() {
        super.m_7651_();
        this.detachSelf(false);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.detachSelf(true);
    }

    @Deprecated
    protected void notifyNeighborsOfTileChange() {
    }

    protected void detachSelf(boolean chunkUnloading) {
        if (this._controller != null) {
            this._controller.detachPart(this, chunkUnloading);
            this._controller = null;
        }
        this.getRegistry().onPartRemovedFromWorld(this);
    }

    private IMultiblockRegistry<Controller> getRegistry() {
        return MultiblockRegistry.INSTANCE;
    }
}

