/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.radio.screen;

import com.teamresourceful.resourcefullib.client.screens.BaseCursorScreen;
import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.AdAstra;
import earth.terrarium.adastra.client.config.AdAstraConfigClient;
import earth.terrarium.adastra.client.config.RadioConfig;
import earth.terrarium.adastra.client.radio.audio.RadioHandler;
import earth.terrarium.adastra.client.radio.screen.RadioList;
import earth.terrarium.adastra.client.utils.Debouncer;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ServerboundRequestStationsPacket;
import earth.terrarium.adastra.common.utils.radio.StationInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadioScreen
extends BaseCursorScreen {
    private static final Debouncer VOLUME_DEBOUNCER = new Debouncer();
    private static final ResourceLocation TEXTURE = new ResourceLocation("ad_astra", "textures/radio/ui.png");
    private static final ResourceLocation CLOCK = new ResourceLocation("ad_astra", "textures/radio/clock.png");
    private static final int WIDTH = 253;
    private static final int HEIGHT = 138;
    private final List<StationInfo> stations = new ArrayList<StationInfo>();
    private final Map<String, String> stationNames = new HashMap<String, String>();
    @Nullable
    private final BlockPos pos;
    private RadioList list;

    public RadioScreen(@Nullable BlockPos pos) {
        super(CommonComponents.f_237098_);
        this.pos = pos;
        NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundRequestStationsPacket());
    }

    protected void m_7856_() {
        int left = (this.f_96543_ - 253) / 2;
        int top = (this.f_96544_ - 138) / 2;
        this.m_142416_((GuiEventListener)new ImageButton(left + 116, top + 83, 21, 21, 253, 0, 21, TEXTURE, 512, 256, button -> {
            if (RadioConfig.volume >= 100) {
                return;
            }
            RadioConfig.volume = Math.min(100, RadioConfig.volume + (Screen.m_96638_() ? 10 : 1));
            VOLUME_DEBOUNCER.debounce(RadioScreen::saveConfigOnThread, 5000L);
        }));
        this.m_142416_((GuiEventListener)new ImageButton(left + 116, top + 105, 21, 21, 274, 0, 21, TEXTURE, 512, 256, button -> {
            if (RadioConfig.volume <= 0) {
                return;
            }
            RadioConfig.volume = Math.max(0, RadioConfig.volume - (Screen.m_96638_() ? 10 : 1));
            VOLUME_DEBOUNCER.debounce(RadioScreen::saveConfigOnThread, 5000L);
        }));
        this.list = (RadioList)this.m_142416_((GuiEventListener)new RadioList(left + 149, top + 84, this.pos));
        if (!this.stations.isEmpty()) {
            this.list.update(this.stations, RadioHandler.getPlaying());
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_280273_(graphics);
        int left = (this.f_96543_ - 253) / 2;
        int top = (this.f_96544_ - 138) / 2;
        graphics.m_280163_(TEXTURE, left, top, 0.0f, 0.0f, 253, 138, 512, 256);
        this.renderClock(graphics, left + 29, top + 92);
        graphics.m_280488_(this.f_96547_, RadioConfig.volume + "%", left + 102 - this.f_96547_.m_92895_(RadioConfig.volume + "%"), top + 114, 1610776);
        graphics.m_280488_(this.f_96547_, "Day " + RadioScreen.getDayTime() / 24000L, left + 16, top + 114, 1610776);
        String playing = RadioHandler.getPlaying();
        if (playing != null && this.stationNames.containsKey(playing.toLowerCase(Locale.ROOT))) {
            RadioScreen.renderScrollingString(graphics, this.f_96547_, (Component)Component.m_237113_((String)this.stationNames.get(playing.toLowerCase(Locale.ROOT))), left + 65, top + 37, left + 188, top + 46, 1610776);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    protected static void renderScrollingString(GuiGraphics graphics, Font font, Component text, int minX, int minY, int maxX, int maxY, int color) {
        int k;
        int i = font.m_92852_((FormattedText)text);
        if (i > (k = maxX - minX)) {
            int l = i - k;
            double d = (double)Util.m_137550_() / 1000.0;
            double e = Math.max((double)l * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = Mth.m_14139_((double)f, (double)0.0, (double)l);
            graphics.m_280588_(minX, minY, maxX, maxY);
            graphics.m_280430_(font, text, minX - (int)g, (minY + maxY - 9) / 2 + 1, color);
            graphics.m_280618_();
        } else {
            graphics.m_280653_(font, text, (minX + maxX) / 2, (minY + maxY - 9) / 2 + 1, color);
        }
    }

    public void renderClock(GuiGraphics graphics, int x, int y) {
        double ratio = 16.666666666666668;
        int dayTime = (int)((RadioScreen.getDayTime() + 6000L) % 12000L);
        boolean isPm = (int)((RadioScreen.getDayTime() + 6000L) % 24000L) >= 12000;
        int hours = dayTime / 1000 == 0 ? 12 : dayTime / 1000;
        int minutes = (int)((double)(dayTime % 1000) / ratio);
        int firstHour = hours / 10;
        int secondHour = hours % 10;
        int firstMinute = minutes / 10;
        int secondMinute = minutes % 10;
        graphics.m_280163_(CLOCK, x, y, 0.0f, (float)(firstHour % 5 * 13), 8, 13, 64, 64);
        graphics.m_280163_(CLOCK, x + 8, y, (float)((int)((float)secondHour / 5.0f) * 8), (float)(secondHour % 5 * 13), 8, 13, 64, 64);
        graphics.m_280163_(CLOCK, x + 16, y, 39.0f, 0.0f, 5, 13, 64, 64);
        graphics.m_280163_(CLOCK, x + 21, y, (float)((int)((float)firstMinute / 5.0f) * 8), (float)(firstMinute % 5 * 13), 8, 13, 64, 64);
        graphics.m_280163_(CLOCK, x + 29, y, (float)((int)((float)secondMinute / 5.0f) * 8), (float)(secondMinute % 5 * 13), 8, 13, 64, 64);
        graphics.m_280163_(CLOCK, x + 37, y, 42.0f, isPm ? 0.0f : 13.0f, 22, 13, 64, 64);
    }

    private static long getDayTime() {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return 0L;
        }
        return Minecraft.m_91087_().f_91073_.m_46468_();
    }

    private static void saveConfigOnThread() {
        Minecraft.m_91087_().m_6937_(() -> AdAstra.CONFIGURATOR.saveConfig(AdAstraConfigClient.class));
    }

    public boolean m_7043_() {
        return false;
    }

    public static void handleStationUpdates(List<StationInfo> stations) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof RadioScreen) {
            RadioScreen screen2 = (RadioScreen)screen;
            screen2.list.update(stations, RadioHandler.getPlaying());
            screen2.stations.clear();
            screen2.stationNames.clear();
            for (StationInfo station : stations) {
                screen2.stationNames.put(station.url().toLowerCase(Locale.ROOT), station.name());
                screen2.stations.add(station);
            }
        }
    }
}

