/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.factoryBoard;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class FactoryPanelEffectPacket
extends SimplePacketBase {
    private FactoryPanelPosition fromPos;
    private FactoryPanelPosition toPos;
    private boolean success;

    public FactoryPanelEffectPacket(FactoryPanelPosition fromPos, FactoryPanelPosition toPos, boolean success) {
        this.fromPos = fromPos;
        this.toPos = toPos;
        this.success = success;
    }

    public FactoryPanelEffectPacket(FriendlyByteBuf buffer) {
        this.fromPos = new FactoryPanelPosition(buffer.m_130135_(), FactoryPanelBlock.PanelSlot.values()[buffer.m_130242_()]);
        this.toPos = new FactoryPanelPosition(buffer.m_130135_(), FactoryPanelBlock.PanelSlot.values()[buffer.m_130242_()]);
        this.success = buffer.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.fromPos.pos());
        buffer.m_130130_(this.fromPos.slot().ordinal());
        buffer.m_130064_(this.toPos.pos());
        buffer.m_130130_(this.toPos.slot().ordinal());
        buffer.writeBoolean(this.success);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            BlockState blockState = level.m_8055_(this.fromPos.pos());
            if (!AllBlocks.FACTORY_GAUGE.has(blockState)) {
                return;
            }
            FactoryPanelBehaviour panelBehaviour = FactoryPanelBehaviour.at((BlockAndTintGetter)level, this.toPos);
            if (panelBehaviour != null) {
                panelBehaviour.bulb.setValue(1.0);
                FactoryPanelConnection connection = panelBehaviour.targetedBy.get(this.fromPos);
                if (connection != null) {
                    connection.success = this.success;
                }
            }
        });
        return true;
    }
}

