/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.lgearbox;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlockEntity;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.AbstractInstance;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import me.duquee.createutilities.blocks.lgearbox.LShapedGearboxBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LShapedGearboxVisual
extends KineticBlockEntityVisual<GearboxBlockEntity> {
    protected final EnumMap<Direction, RotatingInstance> keys = new EnumMap(Direction.class);
    protected Direction sourceFacing;

    public LShapedGearboxVisual(VisualizationContext context, GearboxBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        this.updateSourceFacing();
        Instancer instancer = this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF));
        Direction facing1 = (Direction)this.blockState.m_61143_((Property)LShapedGearboxBlock.FACING_1);
        this.putShaft(blockEntity, facing1);
        Direction facing2 = LShapedGearboxBlock.getAbsolute(facing1, (Direction)this.blockState.m_61143_((Property)LShapedGearboxBlock.FACING_2));
        this.putShaft(blockEntity, facing2);
    }

    private void putShaft(GearboxBlockEntity blockEntity, Direction direction) {
        Direction.Axis axis = direction.m_122434_();
        Instancer instancer = this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF));
        RotatingInstance shaft = (RotatingInstance)instancer.createInstance();
        shaft.setup((KineticBlockEntity)blockEntity, axis, blockEntity.getSpeed()).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, direction).setChanged();
        this.keys.put(direction, shaft);
    }

    protected void updateSourceFacing() {
        if (((GearboxBlockEntity)this.blockEntity).hasSource()) {
            BlockPos source = ((GearboxBlockEntity)this.blockEntity).source.m_121996_((Vec3i)this.pos);
            this.sourceFacing = Direction.m_122372_((float)source.m_123341_(), (float)source.m_123342_(), (float)source.m_123343_());
        } else {
            this.sourceFacing = null;
        }
    }

    public void update(float partialTick) {
        this.updateSourceFacing();
        for (Map.Entry<Direction, RotatingInstance> key : this.keys.entrySet()) {
            Direction direction = key.getKey();
            Direction.Axis axis = direction.m_122434_();
            this.updateRotation(key.getValue(), axis, ((GearboxBlockEntity)this.blockEntity).getSpeed());
        }
    }

    private void updateRotation(RotatingInstance value, Direction.Axis axis, float speed) {
        value.setup((KineticBlockEntity)this.blockEntity, axis, speed).setChanged();
    }

    public void updateLight(float partialTick) {
        this.relight((FlatLit[])this.keys.values().toArray(FlatLit[]::new));
    }

    public void _delete() {
        this.keys.values().forEach(AbstractInstance::delete);
        this.keys.clear();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        this.keys.values().forEach(consumer);
    }
}

