/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.networking.packets;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import me.duquee.createutilities.CreateUtilitiesClient;
import me.duquee.createutilities.blocks.voidtypes.battery.VoidBattery;
import me.duquee.createutilities.blocks.voidtypes.motor.VoidMotorNetworkHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class VoidBatteryUpdatePacket
extends SimplePacketBase {
    private final VoidMotorNetworkHandler.NetworkKey key;
    private final VoidBattery battery;

    public VoidBatteryUpdatePacket(VoidMotorNetworkHandler.NetworkKey key, VoidBattery battery) {
        this.key = key;
        this.battery = battery;
    }

    public VoidBatteryUpdatePacket(FriendlyByteBuf buffer) {
        this.key = VoidMotorNetworkHandler.NetworkKey.fromBuffer(buffer);
        this.battery = new VoidBattery(this.key);
        this.battery.deserializeNBT(buffer.m_130260_());
    }

    public void write(FriendlyByteBuf buffer) {
        this.key.writeToBuffer(buffer);
        buffer.m_130079_(this.battery.serializeNBT());
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> CreateUtilitiesClient.VOID_BATTERIES.storages.put(this.key, this.battery)));
        return true;
    }
}

