/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.integrations.discord.assets;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.integrations.discord.assets.DiscordAsset;
import com.gitlab.cdagaming.unilib.impl.ImageFrame;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.OSUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.Map;
import java.util.function.Function;

public class DiscordAssetUtils {
    public static final Map<String, DiscordAsset> ASSET_LIST = StringUtils.newHashMap();
    public static final Map<String, DiscordAsset> CUSTOM_ASSET_LIST = StringUtils.newHashMap();
    public static final Map<String, DiscordAsset> REALTIME_ASSET_LIST = StringUtils.newHashMap();
    private static final String applicationEndpoint = "https://discord.com/api/oauth2/applications/";
    private static final String assetsEndpoint = "https://cdn.discordapp.com/app-assets/";

    public static boolean isValidId(String clientId) {
        return !StringUtils.isNullOrEmpty((String)clientId) && clientId.length() >= 18 && (Boolean)StringUtils.getValidLong((String)clientId).getFirst() != false;
    }

    public static boolean contains(Map<String, DiscordAsset> list, String key) {
        return !StringUtils.isNullOrEmpty((String)key) && list.containsKey(key);
    }

    public static boolean contains(String key) {
        return DiscordAssetUtils.contains(ASSET_LIST, key);
    }

    public static boolean isCustom(String key) {
        return DiscordAssetUtils.contains(CUSTOM_ASSET_LIST, key) || ImageFrame.isExternalImage((String)key);
    }

    public static DiscordAsset get(Map<String, DiscordAsset> list, String key) {
        String formattedKey = key;
        if (!StringUtils.isNullOrEmpty((String)formattedKey)) {
            if (!list.equals(CUSTOM_ASSET_LIST) && !DiscordAssetUtils.isCustom(formattedKey)) {
                formattedKey = StringUtils.formatAsIcon((String)formattedKey, (String)"_");
            }
            if (DiscordAssetUtils.contains(list, formattedKey)) {
                return list.get(formattedKey);
            }
            if (ImageFrame.isExternalImage((String)formattedKey)) {
                if (!REALTIME_ASSET_LIST.containsKey(formattedKey)) {
                    DiscordAsset asset = new DiscordAsset().setName(formattedKey).setUrl(formattedKey).setType(DiscordAsset.AssetType.CUSTOM);
                    REALTIME_ASSET_LIST.put(formattedKey, asset);
                }
                return REALTIME_ASSET_LIST.get(formattedKey);
            }
        }
        return null;
    }

    public static DiscordAsset get(String key) {
        return DiscordAssetUtils.get(ASSET_LIST, key);
    }

    public static String getKey(Map<String, DiscordAsset> list, String key) {
        DiscordAsset asset = DiscordAssetUtils.get(list, key);
        return asset != null ? asset.getName() : "";
    }

    public static String getKey(String key) {
        return DiscordAssetUtils.getKey(ASSET_LIST, key);
    }

    public static String getId(Map<String, DiscordAsset> list, String key) {
        DiscordAsset asset = DiscordAssetUtils.get(list, key);
        return asset != null ? asset.getId() : "";
    }

    public static String getId(String key) {
        return DiscordAssetUtils.getId(ASSET_LIST, key);
    }

    public static DiscordAsset.AssetType getType(Map<String, DiscordAsset> list, String key) {
        DiscordAsset asset = DiscordAssetUtils.get(list, key);
        return asset != null ? asset.getType() : DiscordAsset.AssetType.LARGE;
    }

    public static DiscordAsset.AssetType getType(String key) {
        return DiscordAssetUtils.getType(ASSET_LIST, key);
    }

    public static String getUrl(Map<String, DiscordAsset> list, String key, Function<String, String> urlFactory) {
        DiscordAsset asset = DiscordAssetUtils.get(list, key);
        if (asset != null) {
            if (!StringUtils.isNullOrEmpty((String)asset.getId())) {
                return asset.getUrl();
            }
            return urlFactory.apply(asset.getUrl());
        }
        return "";
    }

    public static String getUrl(Map<String, DiscordAsset> list, String key) {
        return DiscordAssetUtils.getUrl(list, key, url -> url);
    }

    public static String getUrl(String key, Function<String, String> urlFactory) {
        return DiscordAssetUtils.getUrl(ASSET_LIST, key, urlFactory);
    }

    public static String getUrl(String key) {
        return DiscordAssetUtils.getUrl(key, (String url) -> url);
    }

    public static void emptyData() {
        ASSET_LIST.clear();
        CUSTOM_ASSET_LIST.clear();
    }

    public static DiscordAsset getRandomAsset() {
        try {
            DiscordAsset[] values = ASSET_LIST.values().toArray(new DiscordAsset[0]);
            return values[OSUtils.RANDOM.nextInt(values.length)];
        }
        catch (Throwable ex) {
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.config.invalid.icon.empty", new Object[0]), new Object[0]);
            Constants.LOG.debugError(ex);
            return null;
        }
    }

    public static String getRandomAssetName() {
        DiscordAsset randAsset = DiscordAssetUtils.getRandomAsset();
        return randAsset != null ? randAsset.getName() : "";
    }

    public static String getDiscordAssetUrl(String clientId, String keyId) {
        return !StringUtils.isNullOrEmpty((String)keyId) ? assetsEndpoint + clientId + "/" + keyId + ".png" : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiscordAsset[] loadAssets(String clientId, boolean filterToMain, Map<String, String> dynamicIcons) {
        DiscordAsset[] discordAssetArray;
        Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.load", new Object[]{clientId}), new Object[0]);
        Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.load.credits", new Object[0]), new Object[0]);
        try {
            String url = applicationEndpoint + clientId + "/assets";
            DiscordAsset[] assets = (DiscordAsset[])FileUtils.getJsonFromURL((String)url, DiscordAsset[].class, (FileUtils.Modifiers[])new FileUtils.Modifiers[0]);
            if (filterToMain) {
                ASSET_LIST.clear();
                if (assets != null) {
                    for (DiscordAsset asset : assets) {
                        if (asset.getType() != DiscordAsset.AssetType.CUSTOM) {
                            asset.setUrl(DiscordAssetUtils.getDiscordAssetUrl(clientId, asset.getId()));
                        }
                        if (ASSET_LIST.containsKey(asset.getName())) continue;
                        ASSET_LIST.put(asset.getName(), asset);
                    }
                }
                if (dynamicIcons != null && !dynamicIcons.isEmpty()) {
                    DiscordAssetUtils.syncCustomAssets(dynamicIcons);
                }
            }
            discordAssetArray = assets;
        }
        catch (Throwable ex) {
            DiscordAsset[] discordAssetArray2;
            try {
                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.assets.load", new Object[0]), new Object[0]);
                Constants.LOG.debugError(ex);
                discordAssetArray2 = null;
            }
            catch (Throwable throwable) {
                Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.detected", new Object[]{String.valueOf(ASSET_LIST.size())}), new Object[0]);
                throw throwable;
            }
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.detected", new Object[]{String.valueOf(ASSET_LIST.size())}), new Object[0]);
            return discordAssetArray2;
        }
        Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.detected", new Object[]{String.valueOf(ASSET_LIST.size())}), new Object[0]);
        return discordAssetArray;
    }

    public static DiscordAsset[] loadAssets(String clientId, boolean filterToMain) {
        return DiscordAssetUtils.loadAssets(clientId, filterToMain, null);
    }

    public static void syncCustomAssets(Map<String, String> dynamicIcons) {
        CUSTOM_ASSET_LIST.clear();
        for (Map.Entry<String, String> iconData : dynamicIcons.entrySet()) {
            if (StringUtils.isNullOrEmpty((String)iconData.getKey()) || StringUtils.isNullOrEmpty((String)iconData.getValue())) continue;
            DiscordAsset asset = new DiscordAsset().setName(iconData.getKey()).setUrl(iconData.getValue()).setType(DiscordAsset.AssetType.CUSTOM);
            if (!CUSTOM_ASSET_LIST.containsKey(asset.getName())) {
                CUSTOM_ASSET_LIST.put(asset.getName(), asset);
            }
            ASSET_LIST.put(asset.getName(), asset);
        }
    }
}

