/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.api.prefab;

import com.google.common.base.Suppliers;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import li.cil.manual.api.ManualModel;
import li.cil.manual.api.Tab;
import li.cil.manual.api.content.Document;
import li.cil.manual.api.render.ContentRenderer;
import li.cil.manual.api.util.Constants;
import li.cil.manual.api.util.MarkdownManualRegistryEntry;
import li.cil.manual.api.util.MatchResult;
import li.cil.manual.api.util.PathUtils;
import li.cil.manual.client.document.Strings;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class Manual
implements ManualModel {
    private static final String REDIRECT_PRAGMA = "#redirect ";
    private static final Supplier<RegistrarManager> REGISTRIES = Suppliers.memoize(() -> RegistrarManager.get((String)"markdown_manual"));
    protected final List<History> history = new ArrayList<History>();
    protected int historyIndex;

    public Manual() {
        this.reset();
    }

    @Override
    public Optional<String> pathFor(ItemStack stack) {
        return this.find(Constants.PATH_PROVIDER_REGISTRY, provider -> provider.pathFor(stack));
    }

    @Override
    public Optional<String> pathFor(Level world, BlockPos pos, Direction face) {
        return this.find(Constants.PATH_PROVIDER_REGISTRY, provider -> provider.pathFor(world, pos, face));
    }

    @Override
    public Optional<Document> documentFor(String path) {
        String language = Minecraft.m_91087_().m_91102_().m_264236_();
        Optional<Document> document = this.documentFor(path.replace("%LANGUAGE%", language), language, new LinkedHashSet<String>());
        return document.isPresent() ? document : this.documentFor(path.replace("%LANGUAGE%", "en_us"), "en_us", new LinkedHashSet<String>());
    }

    @Override
    public Optional<ContentRenderer> imageFor(String path) {
        return this.find(Constants.RENDERER_PROVIDER_REGISTRY, provider -> provider.getRenderer(path));
    }

    @Override
    public Iterable<Tab> getTabs() {
        Registrar registry = REGISTRIES.get().get(Constants.TAB_REGISTRY);
        return StreamSupport.stream(registry.spliterator(), false).filter(tab -> this.matches(registry, tab)).collect(Collectors.toList());
    }

    @Override
    public void reset() {
        this.history.clear();
        this.history.add(this.createHistoryEntry(StringUtils.stripStart((String)this.getStartPage(), (String)"/")));
        this.historyIndex = 0;
    }

    @Override
    public void push(String path) {
        if (path.startsWith("/")) {
            throw new IllegalArgumentException("Path must not start with a slash.");
        }
        if (Objects.equals(this.history.get((int)this.historyIndex).path, path)) {
            return;
        }
        if (this.history.size() > this.historyIndex + 1 && Objects.equals(this.history.get((int)(this.historyIndex + 1)).path, path)) {
            ++this.historyIndex;
            return;
        }
        while (this.history.size() > this.historyIndex + 1) {
            this.history.remove(this.history.size() - 1);
        }
        this.history.add(this.createHistoryEntry(path));
        ++this.historyIndex;
    }

    @Override
    public boolean pop() {
        if (this.historyIndex <= 0) {
            return false;
        }
        --this.historyIndex;
        return true;
    }

    @Override
    public String peek() {
        return this.history.get((int)this.historyIndex).path;
    }

    @Override
    public String resolve(String path) {
        return PathUtils.resolve(this.peek(), path);
    }

    @Override
    public <T> Optional<T> getUserData(Class<T> type) {
        return Optional.ofNullable(this.history.get((int)this.historyIndex).userData.get(type));
    }

    @Override
    public <T> void setUserData(T value) {
        this.history.get((int)this.historyIndex).userData.put(value.getClass(), value);
    }

    protected String getStartPage() {
        return "%LANGUAGE%/index.md";
    }

    protected History createHistoryEntry(String path) {
        return new History(path);
    }

    protected <TProvider extends MarkdownManualRegistryEntry, TResult> Optional<TResult> find(ResourceKey<Registry<TProvider>> key, Function<TProvider, Optional<TResult>> lookup) {
        Registrar registry = REGISTRIES.get().get(key);
        return registry.entrySet().stream().map(Map.Entry::getValue).filter(provider -> this.matches(registry, provider)).sorted().map(lookup).filter(Optional::isPresent).findFirst().flatMap(x -> x);
    }

    protected <T extends MarkdownManualRegistryEntry> boolean matches(Registrar<T> registry, T entry) {
        return switch (entry.matches(this)) {
            default -> throw new IncompatibleClassChangeError();
            case MatchResult.PASS -> {
                Optional entryId = registry.getKey(entry);
                Optional manualId = REGISTRIES.get().get(Constants.MANUAL_REGISTRY).getKey((Object)this);
                if (entryId.isPresent() && manualId.isPresent() && Objects.equals(((ResourceKey)entryId.get()).m_135782_().m_135827_(), ((ResourceKey)manualId.get()).m_135782_().m_135827_())) {
                    yield true;
                }
                yield false;
            }
            case MatchResult.MATCH -> true;
            case MatchResult.MISMATCH -> false;
        };
    }

    protected Optional<Document> documentFor(String path, String language, Set<String> seen) {
        if (!seen.add(path)) {
            ArrayList<String> message = new ArrayList<String>();
            message.add(Strings.getRedirectionLoopText());
            message.addAll(seen);
            message.add(path);
            return Optional.of(new Document(message));
        }
        return this.find(Constants.DOCUMENT_PROVIDER_REGISTRY, provider -> provider.getDocument(path, language)).flatMap(document -> {
            List<String> lines = document.getLines();
            if (!lines.isEmpty() && lines.get(0).toLowerCase().startsWith(REDIRECT_PRAGMA)) {
                String redirectPath = lines.get(0).substring(REDIRECT_PRAGMA.length()).trim();
                return this.documentFor(PathUtils.resolve(path, redirectPath), language, seen);
            }
            while (!lines.isEmpty() && StringUtils.isWhitespace((CharSequence)lines.get(0))) {
                lines.remove(0);
            }
            while (!lines.isEmpty() && StringUtils.isWhitespace((CharSequence)lines.get(lines.size() - 1))) {
                lines.remove(lines.size() - 1);
            }
            return Optional.of(document);
        });
    }

    protected static class History {
        public final String path;
        public final Map<Class<?>, Object> userData = new HashMap();

        public History(String path) {
            this.path = path;
        }
    }
}

