/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.part;

import codechicken.multipart.api.part.MultiPart;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.FaceLookup;
import mrtjp.projectred.core.part.IConnectableFacePart;
import mrtjp.projectred.transmission.WireType;
import mrtjp.projectred.transmission.part.IBundledCablePart;
import mrtjp.projectred.transmission.part.IInsulatedRedwirePart;
import mrtjp.projectred.transmission.part.RedwirePart;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class InsulatedRedAlloyWirePart
extends RedwirePart
implements IInsulatedRedwirePart {
    public InsulatedRedAlloyWirePart(WireType wireType) {
        super(wireType);
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return this.getWireType().getTextures().get(this.getSignal() == 0 ? 0 : 1);
    }

    @Override
    protected boolean powerUnderside() {
        return false;
    }

    @Override
    protected int resolveSignal(FaceLookup lookup) {
        MultiPart multiPart = lookup.part;
        if (multiPart instanceof IBundledCablePart) {
            IBundledCablePart bundledPart = (IBundledCablePart)multiPart;
            return (bundledPart.getBundledSignal()[this.getInsulatedColour()] & 0xFF) - 1;
        }
        return super.resolveSignal(lookup);
    }

    @Override
    public boolean canConnectPart(IConnectable part, int dir) {
        if (part instanceof IBundledCablePart) {
            return true;
        }
        if (part instanceof IInsulatedRedwirePart) {
            return ((IInsulatedRedwirePart)part).getInsulatedColour() == this.getInsulatedColour();
        }
        return super.canConnectPart(part, dir);
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    @Override
    public int weakPowerLevel(int side) {
        if (side == this.getSide() || side == (this.getSide() ^ 1)) {
            return 0;
        }
        int r = IConnectableFacePart.absoluteRot((IConnectableFacePart)this, (int)side);
        if (!this.maskConnects(r)) {
            return 0;
        }
        return super.weakPowerLevel(side);
    }

    @Override
    public int getInsulatedColour() {
        return this.getWireType().getColourIdx();
    }
}

