/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.items;

import com.razz.decocraft.common.blocks.DecocraftBlock;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;

public class DecoBlockItem
extends BlockItem {
    private static final float CRAFTING_SCALE = 32.0f;
    private int material = -1;
    private int red = -1;
    private int green = -1;
    private int blue = -1;

    public DecoBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
        DecocraftBlock decoblock = (DecocraftBlock)block;
        if (decoblock.meta.crafting_color[0] >= 0.0f && decoblock.meta.crafting_color[1] >= 0.0f && decoblock.meta.crafting_color[2] >= 0.0f) {
            this.red = Math.round(decoblock.meta.crafting_color[0] / 100.0f * 32.0f);
            this.green = Math.round(decoblock.meta.crafting_color[1] / 100.0f * 32.0f);
            this.blue = Math.round(decoblock.meta.crafting_color[2] / 100.0f * 32.0f);
        }
        try {
            AABB bounds = decoblock.getShape()[0].m_83215_();
            this.material = Math.min(Math.max((int)Math.ceil((bounds.f_82291_ - bounds.f_82288_) * (bounds.f_82292_ - bounds.f_82289_) * (bounds.f_82293_ - bounds.f_82290_)), 1), 10);
        }
        catch (UnsupportedOperationException e) {
            System.out.println(String.format("%s %s", new Object[]{e, decoblock}));
            this.material = 1;
        }
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getMaterial() {
        return this.material;
    }
}

