/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.tileentities;

import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DecocraftTileEntity
extends BlockEntity {
    private JsonContainer.Entry meta;
    private int counter;
    private int frametime;

    public DecocraftTileEntity(BlockPos pos, BlockState state) {
        super(ModuleTileEntities.DECOCRAFT, pos, state);
    }

    public DecocraftTileEntity(BlockPos pos, BlockState state, JsonContainer.Entry meta) {
        this(pos, state);
        if (meta != null) {
            this.meta = meta;
            this.counter = meta.script.counter;
            this.frametime = meta.flipbook.frametime;
        } else {
            this.meta = null;
            this.counter = -1;
            this.frametime = -1;
        }
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        DecocraftTileEntity be = (DecocraftTileEntity)blockEntity;
        if (be.counter >= 0) {
            --be.counter;
            if (be.counter == 0) {
                be.counter = be.meta.script.counter;
                DecocraftBlock.script(level, pos, state, be.meta.script.trigger);
            }
        }
        if (be.frametime >= 0) {
            --be.frametime;
            if (be.frametime == 0) {
                be.frametime = be.meta.flipbook.frametime;
                Pattern pattern = Pattern.compile("(?<mat>[a-zA-Z_0-9]+)\\.(?<num>\\d+)");
                Matcher matcher = pattern.matcher(be.meta.material);
                if (matcher.find()) {
                    String mat = String.format("%s.%02d", matcher.group(1), Integer.parseInt(matcher.group(2)) + 1);
                    if (!ModuleBlocks.DECOBLOCKS.containsKey(mat)) {
                        mat = String.format("%s.%02d", matcher.group(1), 0);
                    }
                    DecocraftBlock.scriptLink(level, pos, state, mat);
                } else {
                    System.out.println(matcher);
                }
            }
        }
    }
}

