/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.client;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mrtjp.projectred.core.ProjectRedCore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.joml.Matrix4f;

public class FixedScalePostChain
extends PostChain {
    private final Map<String, Double> fixedRenderTargetScales = new HashMap<String, Double>();

    public FixedScalePostChain(TextureManager textureManager, ResourceManager resourceManager, RenderTarget renderTarget, ResourceLocation location) throws IOException, JsonSyntaxException {
        super(textureManager, resourceManager, renderTarget, location);
    }

    public FixedScalePostChain(ResourceLocation location) throws IOException {
        this(Minecraft.m_91087_().m_91097_(), Minecraft.m_91087_().m_91098_(), Minecraft.m_91087_().m_91385_(), location);
    }

    public FixedScalePostChain(String modId, String filename) throws IOException {
        this(new ResourceLocation(modId, "shaders/post/" + filename + ".json"));
    }

    public void addFixedTargetScale(String name, double scale) {
        this.fixedRenderTargetScales.put(name, scale);
    }

    public void resizeIfNeeded() {
        if (this.f_110013_ != this.f_110006_.f_83915_ || this.f_110014_ != this.f_110006_.f_83916_) {
            this.m_110025_(this.f_110006_.f_83915_, this.f_110006_.f_83916_);
        }
    }

    public void m_110025_(int newWidth, int newHeight) {
        ProjectRedCore.LOGGER.debug("Resizing FixedScalePostChain from {}x{} to {}x{}", (Object)this.f_110013_, (Object)this.f_110014_, (Object)newWidth, (Object)newHeight);
        super.m_110025_(newWidth, newHeight);
        for (Map.Entry<String, Double> entry : this.fixedRenderTargetScales.entrySet()) {
            String name = entry.getKey();
            Double scale = entry.getValue();
            RenderTarget target = (RenderTarget)this.f_110010_.get(name);
            int newTargetWidth = (int)Math.ceil((double)newWidth * scale);
            int newTargetHeight = (int)Math.ceil((double)newHeight * scale);
            ProjectRedCore.LOGGER.debug("Resizing target {} from {}x{} to {}x{}", (Object)entry.getKey(), (Object)target.f_83915_, (Object)target.f_83916_, (Object)newTargetWidth, (Object)newTargetHeight);
            target.m_83941_(newTargetWidth, newTargetHeight, Minecraft.f_91002_);
        }
        for (PostPass pass : this.f_110009_) {
            Matrix4f orthoMatrix = new Matrix4f().setOrtho(0.0f, (float)pass.f_110052_.f_83915_, 0.0f, (float)pass.f_110052_.f_83916_, 0.1f, 1000.0f);
            pass.m_253214_(orthoMatrix);
        }
    }
}

