/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.lib;

import codechicken.lib.render.CCModel;
import codechicken.lib.util.VectorUtils;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ModelVoxelShape
extends VoxelShape {
    private final VoxelShape parent;
    private final List<Tri> tris;

    public ModelVoxelShape(VoxelShape parent, List<Tri> tris) {
        super(parent.f_83211_);
        this.parent = parent;
        this.tris = tris;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModelVoxelShape(VoxelShape parent, CCModel model) {
        this(parent, ModelVoxelShape.trisFromCCModel(model));
    }

    public DoubleList m_7700_(Direction.Axis axis) {
        return this.parent.m_7700_(axis);
    }

    @Nullable
    public BlockHitResult m_83220_(Vec3 start, Vec3 end, BlockPos pos) {
        Vector3 relativeStart = new Vector3(start).subtract((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        Vector3 relativeEnd = new Vector3(end).subtract((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        Vector3 intersection = null;
        Direction side = null;
        double dist = Double.MAX_VALUE;
        LinkedList<Tri> hits = new LinkedList<Tri>();
        for (Tri tri : this.tris) {
            Vector3 i = tri.getIntersection(relativeStart, relativeEnd, true, false);
            if (i == null) continue;
            hits.add(tri);
            double d = relativeStart.copy().subtract(i).magSquared();
            if (!(dist > d)) continue;
            intersection = i;
            side = tri.side;
            dist = d;
        }
        if (intersection == null) {
            return null;
        }
        return new BlockHitResult(intersection.add(pos).vec3(), side, pos, true);
    }

    public static ModelVoxelShape fromTriangles(VoxelShape parent, Vertex5[] verts) {
        return new ModelVoxelShape(parent, ModelVoxelShape.trisFromTriangles(verts));
    }

    public static ModelVoxelShape fromQuads(VoxelShape parent, Vertex5[] verts) {
        return new ModelVoxelShape(parent, ModelVoxelShape.trisFromQuads(verts));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<Tri> trisFromCCModel(CCModel model) {
        return model.vertexMode == VertexFormat.Mode.QUADS ? ModelVoxelShape.trisFromQuads(model.verts) : ModelVoxelShape.trisFromTriangles(model.verts);
    }

    public static List<Tri> trisFromQuads(Vertex5[] verts) {
        int vp = 4;
        LinkedList<Tri> triList = new LinkedList<Tri>();
        for (int i = 0; i < verts.length; i += vp) {
            triList.add(new Tri(verts[i].copy(), verts[i + 1].copy(), verts[i + 2].copy()));
            triList.add(new Tri(verts[i].copy(), verts[i + 2].copy(), verts[i + 3].copy()));
        }
        return triList;
    }

    public static List<Tri> trisFromTriangles(Vertex5[] verts) {
        int vp = 3;
        LinkedList<Tri> triList = new LinkedList<Tri>();
        for (int i = 0; i < verts.length; i += vp) {
            triList.add(new Tri(verts[i].copy(), verts[i + 1].copy(), verts[i + 2].copy()));
        }
        return triList;
    }

    public static class Tri {
        public final Vector3 v0;
        public final Vector3 v1;
        public final Vector3 v2;
        public final Vector3 normal;
        public final Direction side;
        private final Vector3 u;
        private final Vector3 v;
        private final double uu;
        private final double uv;
        private final double vv;
        private final double D;

        public Tri(Vector3 v0, Vector3 v1, Vector3 v2) {
            this.v0 = v0;
            this.v1 = v1;
            this.v2 = v2;
            this.normal = VectorUtils.calculateNormal((Vector3[])new Vector3[]{v0, v1, v2});
            this.side = Objects.requireNonNull(VectorUtils.calcNormalSide((Vector3)this.normal));
            this.u = v1.copy().subtract(v0);
            this.v = v2.copy().subtract(v0);
            this.uu = this.u.dotProduct(this.u);
            this.uv = this.u.dotProduct(this.v);
            this.vv = this.v.dotProduct(this.v);
            this.D = this.uv * this.uv - this.uu * this.vv;
        }

        public Tri(Vertex5 v0, Vertex5 v1, Vertex5 v2) {
            this(v0.vec, v1.vec, v2.vec);
        }

        @Nullable
        public Vector3 getIntersection(Vector3 r0, Vector3 r1, boolean cull, boolean segment) {
            Vector3 dir = r1.copy().subtract(r0);
            Vector3 w0 = r0.copy().subtract(this.v0);
            double a = -this.normal.dotProduct(w0);
            double b = this.normal.dotProduct(dir);
            if (Math.abs(b) < 1.0E-8) {
                return null;
            }
            if (cull && b > 0.0) {
                return null;
            }
            double r = a / b;
            if (r < 0.0 || segment && r > 1.0) {
                return null;
            }
            Vector3 intersection = r0.copy().add(dir.x * r, dir.y * r, dir.z * r);
            Vector3 w = intersection.copy().subtract(this.v0);
            double wu = w.dotProduct(this.u);
            double wv = w.dotProduct(this.v);
            double s = (this.uv * wv - this.vv * wu) / this.D;
            if (s < 0.0 || s > 1.0) {
                return null;
            }
            double t = (this.uv * wu - this.uu * wv) / this.D;
            if (t < 0.0 || s + t > 1.0) {
                return null;
            }
            return intersection;
        }
    }
}

