/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear;

import com.simibubi.create.AllFluids;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.List;
import java.util.function.Supplier;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.nuclearteam.createnuclear.CNEffects;
import net.nuclearteam.createnuclear.CNTags;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.content.decoration.palettes.CNPaletteStoneTypes;
import org.joml.Vector3f;

public class CNFluids {
    public static final FluidEntry<ForgeFlowingFluid.Flowing> URANIUM = ((FluidBuilder)CreateNuclear.REGISTRATE.standardFluid("uranium", SolidRenderedPlaceableFluidtype.create(3735304, () -> Float.valueOf(0.03125f))).lang("Liquid Uranium").tag(new TagKey[]{CNTags.CNFluidTags.URANIUM.tag}).properties(p -> p.viscosity(2500).density(1600).canSwim(false).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11783_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_).canDrown(false)).fluidProperties(f -> f.levelDecreasePerBlock(2).tickRate(15).slopeFindDistance(6).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().tag(new TagKey[]{CNTags.forgeItemTag("buckets/uranium")}).lang("Uranium Bucket").build()).register();

    public static void register() {
    }

    public static void handleFluidEffect(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_6084_() && !entity.m_5833_()) {
            if (entity.f_19797_ % 20 == 0) {
                return;
            }
            if (entity.isInFluidType(URANIUM.getType())) {
                entity.m_7292_(new MobEffectInstance((MobEffect)CNEffects.RADIATION.get(), 100, 0));
            }
        }
    }

    public static void registerFluidInteractions() {
        Supplier<BlockState> autuniteState = () -> ((Block)CNPaletteStoneTypes.AUTUNITE.getBaseBlock().get()).m_49966_();
        FluidType uraniumType = ((ForgeFlowingFluid.Flowing)URANIUM.get()).getFluidType();
        List<FluidType> sourceFluids = List.of((FluidType)ForgeMod.LAVA_TYPE.get(), (FluidType)ForgeMod.WATER_TYPE.get());
        for (FluidType source : sourceFluids) {
            FluidInteractionRegistry.addInteraction((FluidType)source, (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(uraniumType, fs -> (BlockState)autuniteState.get()));
        }
    }

    private static class SolidRenderedPlaceableFluidtype
    extends AllFluids.TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidtype fluidtype = new SolidRenderedPlaceableFluidtype(p, s, f);
                fluidtype.fogColor = new Color(fogColor, false).asVectorF();
                fluidtype.fogDistance = fogDistance;
                return fluidtype;
            };
        }

        private SolidRenderedPlaceableFluidtype(FluidType.Properties properties, ResourceLocation stillTecture, ResourceLocation flowingTexture) {
            super(properties, stillTecture, flowingTexture);
        }

        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        protected int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
            return 3735304;
        }

        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }
}

