/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.controller;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.foundation.utility.IInteractionChecker;
import java.util.List;
import lib.multiblock.SimpleMultiBlockAislePatternBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.CNItems;
import net.nuclearteam.createnuclear.CNPackets;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.content.multiblock.IHeat;
import net.nuclearteam.createnuclear.content.multiblock.controller.EventTriggerPacket;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlock;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerInventory;
import net.nuclearteam.createnuclear.content.multiblock.input.ReactorInputEntity;
import net.nuclearteam.createnuclear.content.multiblock.output.ReactorOutput;
import net.nuclearteam.createnuclear.content.multiblock.output.ReactorOutputEntity;

public class ReactorControllerBlockEntity
extends SmartBlockEntity
implements IInteractionChecker,
IHaveGoggleInformation {
    public boolean destroyed = false;
    public boolean created = false;
    public boolean test = true;
    public int speed = 16;
    public boolean sendUpdate;
    public ReactorControllerBlock controller;
    public ReactorControllerInventory inventory;
    public State powered = State.OFF;
    public float reactorPower;
    public float lastReactorPower;
    int overFlowHeatTimer = 0;
    int overFlowLimiter = 30;
    double overHeat = 0.0;
    public int baseUraniumHeat = 25;
    public int baseGraphiteHeat = -10;
    public int proximityUraniumHeat = 5;
    public int proximityGraphiteHeat = -5;
    public int maxUraniumPerGraphite = 3;
    public int graphiteTimer = 3600;
    public int uraniumTimer = 3600;
    public int countUraniumRod;
    public int countGraphiteRod;
    public int heat;
    public double total;
    public CompoundTag screen_pattern = new CompoundTag();
    public ItemStack configuredPattern;
    private ItemStack fuelItem;
    private ItemStack coolerItem;
    private final int[][] formattedPattern = new int[][]{{99, 99, 99, 0, 1, 2, 99, 99, 99}, {99, 99, 3, 4, 5, 6, 7, 99, 99}, {99, 8, 9, 10, 11, 12, 13, 14, 99}, {15, 16, 17, 18, 19, 20, 21, 22, 23}, {24, 25, 26, 27, 28, 29, 30, 31, 32}, {33, 34, 35, 36, 37, 38, 39, 40, 41}, {99, 42, 43, 44, 45, 46, 47, 48, 99}, {99, 99, 49, 50, 51, 52, 53, 99, 99}, {99, 99, 99, 54, 55, 56, 99, 99, 99}};
    private final int[][] offsets = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}};

    public ReactorControllerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new ReactorControllerInventory(this);
        this.configuredPattern = ItemStack.f_41583_;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean getAssembled() {
        BlockState state = this.m_58900_();
        return (Boolean)state.m_61143_((Property)ReactorControllerBlock.ASSEMBLED);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!this.configuredPattern.m_41784_().m_128456_()) {
            CreateLang.translate((String)"gui.gauge.info_header", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            IHeat.HeatLevel.getName("reactor_controller").style(ChatFormatting.GRAY).forGoggles(tooltip);
            IHeat.HeatLevel.getFormattedHeatText(this.configuredPattern.m_41784_().m_128451_("heat")).forGoggles(tooltip);
            if (this.fuelItem.m_41619_()) {
                IHeat.HeatLevel.getFormattedItemText(new ItemStack((ItemLike)CNItems.URANIUM_ROD.m_5456_(), 1), true).forGoggles(tooltip);
            } else {
                IHeat.HeatLevel.getFormattedItemText(this.fuelItem, false).forGoggles(tooltip);
            }
            if (this.fuelItem.m_41619_()) {
                IHeat.HeatLevel.getFormattedItemText(new ItemStack((ItemLike)CNItems.GRAPHITE_ROD.m_5456_(), 1), true).forGoggles(tooltip);
            } else {
                IHeat.HeatLevel.getFormattedItemText(this.coolerItem, false).forGoggles(tooltip);
            }
        }
        return true;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        if (!clientPacket) {
            this.inventory.deserializeNBT(compound.m_128469_("pattern"));
        }
        this.configuredPattern = ItemStack.m_41712_((CompoundTag)compound.m_128469_("items"));
        if (ItemStack.m_41712_((CompoundTag)compound.m_128469_("cooler")) != null || ItemStack.m_41712_((CompoundTag)compound.m_128469_("fuel")) != null) {
            this.coolerItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_("cooler"));
            this.fuelItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_("fuel"));
        }
        this.total = compound.m_128459_("total");
        super.read(compound, clientPacket);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        if (!clientPacket) {
            compound.m_128365_("pattern", (Tag)this.inventory.serializeNBT());
        }
        compound.m_128365_("items", (Tag)this.configuredPattern.serializeNBT());
        if (this.coolerItem != null || this.fuelItem != null) {
            compound.m_128365_("cooler", (Tag)this.coolerItem.serializeNBT());
            compound.m_128365_("fuel", (Tag)this.fuelItem.serializeNBT());
        }
        compound.m_128347_("total", this.calculateProgress());
        super.write(compound, clientPacket);
    }

    private void explodeReactorCore(Level level, BlockPos pos) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos currentPos = pos.m_7918_(x, y, z);
                    if (!level.m_8055_(currentPos).m_60713_((Block)CNBlocks.REACTOR_CORE.get())) continue;
                    Explosion explosion = new Explosion(level, null, (double)currentPos.m_123341_(), (double)currentPos.m_123342_(), (double)currentPos.m_123343_(), 4.0f, false, Explosion.BlockInteraction.DESTROY);
                    explosion.m_46061_();
                    explosion.m_46075_(true);
                }
            }
        }
    }

    public void tick() {
        BlockEntity blockEntity;
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.isEmptyConfiguredPattern() && (blockEntity = this.f_58857_.m_7702_(this.getBlockPosForReactor('I'))) instanceof ReactorInputEntity) {
            ReactorInputEntity be = (ReactorInputEntity)blockEntity;
            CompoundTag tag = be.serializeNBT();
            ListTag inventoryTag = tag.m_128469_("Inventory").m_128437_("Items", 10);
            this.fuelItem = ItemStack.m_41712_((CompoundTag)inventoryTag.m_128728_(0));
            this.coolerItem = ItemStack.m_41712_((CompoundTag)inventoryTag.m_128728_(1));
            if (this.fuelItem.m_41613_() > 0 && this.coolerItem.m_41613_() > 0) {
                this.configuredPattern.m_41784_().m_128347_("heat", this.calculateHeat(tag));
                if (this.updateTimers()) {
                    be.inventory.extractItem(0, 1, false);
                    be.inventory.extractItem(1, 1, false);
                    this.total = this.calculateProgress();
                    int heat = (int)this.configuredPattern.m_41784_().m_128459_("heat");
                    if (IHeat.HeatLevel.of(heat) == IHeat.HeatLevel.SAFETY || IHeat.HeatLevel.of(heat) == IHeat.HeatLevel.CAUTION || IHeat.HeatLevel.of(heat) == IHeat.HeatLevel.WARNING) {
                        this.rotate(this.m_58900_(), new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() + ReactorControllerBlockEntity.FindController('O').m_123342_(), this.m_58899_().m_123343_()), this.m_58904_(), heat / 4);
                    } else {
                        EventTriggerPacket packet = new EventTriggerPacket(600);
                        CreateNuclear.LOGGER.warn("hum EventTriggerBlock ? {}", (Object)packet);
                        CNPackets.sendToNear(this.f_58857_, this.m_58899_(), 32, (Object)packet);
                        this.rotate(this.m_58900_(), new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() + ReactorControllerBlockEntity.FindController('O').m_123342_(), this.m_58899_().m_123343_()), this.m_58904_(), 0);
                    }
                    return;
                }
            } else {
                this.rotate(this.m_58900_(), new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() + ReactorControllerBlockEntity.FindController('O').m_123342_(), this.m_58899_().m_123343_()), this.m_58904_(), 0);
            }
            this.notifyUpdate();
        }
    }

    private boolean isEmptyConfiguredPattern() {
        return !this.configuredPattern.m_41619_() || !this.configuredPattern.m_41784_().m_128456_();
    }

    private boolean updateTimers() {
        this.total -= 1.0;
        return this.total <= 0.0;
    }

    private double calculateProgress() {
        this.countGraphiteRod = this.configuredPattern.m_41784_().m_128451_("countGraphiteRod");
        this.countUraniumRod = this.configuredPattern.m_41784_().m_128451_("countUraniumRod");
        double totalGraphiteRodLife = (double)this.graphiteTimer / (double)this.countGraphiteRod;
        double totalUraniumRodLife = (double)this.uraniumTimer / (double)this.countUraniumRod;
        return totalGraphiteRodLife + totalUraniumRodLife;
    }

    private double calculateHeat(CompoundTag tag) {
        this.countGraphiteRod = this.configuredPattern.m_41784_().m_128451_("countGraphiteRod");
        this.countUraniumRod = this.configuredPattern.m_41784_().m_128451_("countUraniumRod");
        this.heat = 0;
        if (this.countUraniumRod > this.countGraphiteRod * this.maxUraniumPerGraphite) {
            ++this.overFlowHeatTimer;
            if (this.overFlowHeatTimer >= this.overFlowLimiter) {
                this.overHeat += 1.0;
                this.overFlowHeatTimer = 0;
                if (this.overFlowLimiter > 2) {
                    --this.overFlowLimiter;
                }
            }
        } else {
            this.overFlowHeatTimer = 0;
            this.overFlowLimiter = 30;
            this.overHeat = this.overHeat > 0.0 ? (this.overHeat -= 2.0) : 0.0;
        }
        String currentRod = "";
        ListTag list = this.inventory.getStackInSlot(0).m_41784_().m_128469_("pattern").m_128437_("Items", 10);
        for (int i = 0; i < list.size(); ++i) {
            if (list.m_128728_(i).m_128461_("id").equals("createnuclear:uranium_rod")) {
                this.heat += this.baseUraniumHeat;
                currentRod = "u";
            } else if (list.m_128728_(i).m_128461_("id").equals("createnuclear:graphite_rod")) {
                this.heat += this.baseGraphiteHeat;
                currentRod = "g";
            }
            for (int j = 0; j < this.formattedPattern.length; ++j) {
                for (int k = 0; k < this.formattedPattern[j].length; ++k) {
                    if (this.formattedPattern[j][k] == 99 || list.m_128728_(i).m_128451_("Slot") != this.formattedPattern[j][k]) continue;
                    for (int[] offset : this.offsets) {
                        int nj = j + offset[0];
                        int nk = k + offset[1];
                        if (nj < 0 || nj >= this.formattedPattern.length || nk < 0 || nk >= this.formattedPattern[j].length) continue;
                        int neighborSlot = this.formattedPattern[nj][nk];
                        for (int l = 0; l < list.size(); ++l) {
                            if (list.m_128728_(l).m_128451_("Slot") != neighborSlot || !currentRod.equals("u")) continue;
                            String id = list.m_128728_(l).m_128461_("id");
                            if (id.equals("createnuclear:uranium_rod")) {
                                this.heat += this.proximityUraniumHeat;
                                continue;
                            }
                            if (!id.equals("createnuclear:graphite_rod")) continue;
                            this.heat += this.proximityGraphiteHeat;
                        }
                    }
                }
            }
        }
        return (double)this.heat + this.overHeat;
    }

    private BlockPos getBlockPosForReactor(char character) {
        int[][] directions;
        BlockPos pos = ReactorControllerBlockEntity.FindController(character);
        BlockPos posController = this.m_58899_();
        BlockPos posInput = new BlockPos(posController.m_123341_(), posController.m_123342_(), posController.m_123343_());
        for (int[] direction : directions = new int[][]{{0, 0, pos.m_123341_()}, {0, 0, -pos.m_123341_()}, {-pos.m_123341_(), 0, 0}, {pos.m_123341_(), 0, 0}}) {
            BlockPos newPos = posController.m_7918_(direction[0], direction[1], direction[2]);
            if (!this.f_58857_.m_8055_(newPos).m_60713_((Block)CNBlocks.REACTOR_INPUT.get())) continue;
            posInput = newPos;
            break;
        }
        return posInput;
    }

    private CompoundTag convertePattern(CompoundTag compoundTag) {
        ListTag pattern = compoundTag.m_128437_("Items", 10);
        int[][] list = new int[][]{{99, 99, 99, 0, 1, 2, 99, 99, 99}, {99, 99, 3, 4, 5, 6, 7, 99, 99}, {99, 8, 9, 10, 11, 12, 13, 14, 99}, {15, 16, 17, 18, 19, 20, 21, 22, 23}, {24, 25, 26, 27, 28, 29, 30, 31, 32}, {33, 34, 35, 36, 37, 38, 39, 40, 41}, {99, 42, 43, 44, 45, 46, 47, 48, 99}, {99, 99, 49, 50, 51, 52, 53, 99, 99}, {99, 99, 99, 54, 55, 56, 99, 99, 99}};
        return null;
    }

    private static BlockPos FindController(char character) {
        return SimpleMultiBlockAislePatternBuilder.start().aisle("AAAAA", "AAAAA", "AAAAA", "AAAAA", "AAAAA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AAIAA", "ADADA", "BACAB", "ADADA", "AA*AA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AAAAA", "AAAAA", "AAAAA", "AAAAA", "AAOAA").where('A', a -> a.m_61168_().m_60713_((Block)CNBlocks.REACTOR_CASING.get())).where('B', a -> a.m_61168_().m_60713_((Block)CNBlocks.REACTOR_FRAME.get())).where('C', a -> a.m_61168_().m_60713_((Block)CNBlocks.REACTOR_CORE.get())).where('D', a -> a.m_61168_().m_60713_((Block)CNBlocks.REACTOR_COOLER.get())).where('*', a -> a.m_61168_().m_60713_((Block)CNBlocks.REACTOR_CONTROLLER.get())).where('O', a -> a.m_61168_().m_60713_((Block)CNBlocks.REACTOR_OUTPUT.get())).where('I', a -> a.m_61168_().m_60713_((Block)CNBlocks.REACTOR_INPUT.get())).getDistanceController(character);
    }

    public void rotate(BlockState state, BlockPos pos, Level level, int rotation) {
        if (level.m_8055_(pos).m_60713_((Block)CNBlocks.REACTOR_OUTPUT.get()) && rotation > 0) {
            Block block = level.m_8055_(pos).m_60734_();
            if (block instanceof ReactorOutput) {
                ReactorOutput block2 = (ReactorOutput)block;
                ReactorOutputEntity entity = (ReactorOutputEntity)block2.getBlockEntityType().m_58949_((BlockGetter)level, pos);
                if (((Boolean)state.m_61143_((Property)ReactorControllerBlock.ASSEMBLED)).booleanValue()) {
                    entity.speed = rotation;
                    entity.heat = rotation;
                } else {
                    entity.speed = 0;
                    entity.heat = 0.0f;
                }
                entity.updateSpeed = true;
                entity.updateGeneratedRotation();
                entity.setSpeed(rotation);
            }
        } else {
            Object entity = level.m_8055_(pos).m_60734_();
            if (entity instanceof ReactorOutput) {
                ReactorOutput block = (ReactorOutput)((Object)entity);
                entity = (ReactorOutputEntity)block.getBlockEntityType().m_58949_((BlockGetter)level, pos);
                ((ReactorOutputEntity)((Object)entity)).setSpeed(0);
                ((ReactorOutputEntity)((Object)entity)).heat = 0.0f;
                ((ReactorOutputEntity)((Object)entity)).updateSpeed = true;
                entity.updateGeneratedRotation();
            }
        }
    }

    public InteractionResult onClick(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_150930_((Item)CNItems.REACTOR_BLUEPRINT.get()) && !heldItem.m_41619_()) {
            if (this.configuredPattern.m_41619_()) {
                this.inventory.setStackInSlot(0, heldItem);
                this.configuredPattern = heldItem;
            }
            this.notifyUpdate();
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_41619_() && this.configuredPattern.m_41619_()) {
            if (!this.f_58857_.f_46443_) {
                if (player.m_36356_(this.configuredPattern)) {
                    this.configuredPattern = ItemStack.f_41583_;
                } else {
                    player.m_21008_(hand, this.configuredPattern);
                    this.inventory.setStackInSlot(0, ItemStack.f_41583_);
                }
                this.notifyUpdate();
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static enum State {
        ON,
        OFF;

    }
}

