/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.core;

import lib.multiblock.SimpleMultiBlockAislePatternBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.content.multiblock.IHeat;
import net.nuclearteam.createnuclear.content.multiblock.casing.ReactorCasingEntity;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlockEntity;

public class ReactorCoreEntity
extends ReactorCasingEntity {
    private int countdownTicks = 0;

    public ReactorCoreEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        BlockPos controllerPos = this.getBlockPosForReactor();
        BlockEntity blockEntity = this.f_58857_.m_7702_(controllerPos);
        if (blockEntity instanceof ReactorControllerBlockEntity) {
            ReactorControllerBlockEntity reactorController = (ReactorControllerBlockEntity)blockEntity;
            int heat = (int)reactorController.configuredPattern.m_41784_().m_128459_("heat");
            if (IHeat.HeatLevel.of(heat) == IHeat.HeatLevel.DANGER) {
                if (this.countdownTicks >= 600) {
                    this.explodeReactorCore(this.f_58857_, this.m_58899_());
                } else {
                    ++this.countdownTicks;
                }
            } else {
                this.countdownTicks = 0;
            }
        }
    }

    private void explodeReactorCore(Level world, BlockPos pos) {
        this.f_58857_.m_254849_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 20.0f, Level.ExplosionInteraction.BLOCK);
    }

    private static BlockPos FindController(char character) {
        return SimpleMultiBlockAislePatternBuilder.start().aisle("AAAAA", "AAAAA", "AAAAA", "AAAAA", "AAAAA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AAIAA", "ADADA", "BACAB", "ADADA", "AA*AA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AAAAA", "AAAAA", "AAAAA", "AAAAA", "AAOAA").where('A', a -> a.m_61168_().m_60713_((Block)CNBlocks.REACTOR_CASING.get())).where('B', a -> a.m_61168_().m_60713_((Block)CNBlocks.REACTOR_FRAME.get())).where('C', a -> a.m_61168_().m_60713_((Block)CNBlocks.REACTOR_CORE.get())).where('D', a -> a.m_61168_().m_60713_((Block)CNBlocks.REACTOR_COOLER.get())).where('*', a -> a.m_61168_().m_60713_((Block)CNBlocks.REACTOR_CONTROLLER.get())).where('O', a -> a.m_61168_().m_60713_((Block)CNBlocks.REACTOR_OUTPUT.get())).where('I', a -> a.m_61168_().m_60713_((Block)CNBlocks.REACTOR_INPUT.get())).getDistanceController(character);
    }

    private BlockPos getBlockPosForReactor() {
        int[][][] directions;
        BlockPos posController = this.m_58899_();
        BlockPos posInput = new BlockPos(posController.m_123341_(), posController.m_123342_(), posController.m_123343_());
        int[][][] nArrayArray = directions = new int[][][]{new int[][]{{0, 2, 2}, {0, 1, 2}, {0, 0, 2}, {0, -1, 2}, {0, -2, 2}}, new int[][]{{0, 2, -2}, {0, 1, -2}, {0, 0, -2}, {0, -1, -2}, {0, -2, -2}}, new int[][]{{2, 2, 0}, {2, 1, 0}, {2, 0, 0}, {2, -1, 0}, {2, -2, 0}}, new int[][]{{-2, 2, 0}, {-2, 1, 0}, {-2, 0, 0}, {-2, -1, 0}, {-2, -2, 0}}};
        int n = nArrayArray.length;
        block0: for (int i = 0; i < n; ++i) {
            int[][] direction;
            for (int[] dir : direction = nArrayArray[i]) {
                BlockPos newPos = posController.m_7918_(dir[0], dir[1], dir[2]);
                if (!this.f_58857_.m_8055_(newPos).m_60713_((Block)CNBlocks.REACTOR_CONTROLLER.get())) continue;
                posInput = newPos;
                continue block0;
            }
        }
        return posInput;
    }
}

