/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.foundation.data.recipe;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.data.recipe.CreateRecipeProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.List;
import java.util.function.UnaryOperator;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.CNItems;
import net.nuclearteam.createnuclear.CNTags;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.content.equipment.armor.AntiRadiationArmorItem;
import net.nuclearteam.createnuclear.content.equipment.cloth.ClothItem;

public class CNStandardRecipeGen
extends CreateRecipeProvider {
    private final String CRAFTING = this.enterFolder("crafting");
    CreateRecipeProvider.GeneratedRecipe WHITE_CLOTH_FROM_STRING = this.create((Supplier<ItemLike>)((Supplier)ClothItem.Cloths.WHITE_CLOTH::getItem)).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> Items.f_42401_)).viaShaped(b -> b.m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42401_).m_126130_("###").m_126130_("###").m_271710_(true));
    CreateRecipeProvider.GeneratedRecipe WHITE_CLOTH_FROM_WOOL = this.create((Supplier<ItemLike>)((Supplier)ClothItem.Cloths.WHITE_CLOTH::getItem)).returns(6).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> Items.f_41870_)).withSuffix("_wool").viaShaped(b -> b.m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50041_).m_126130_("###").m_126130_("###").m_271710_(true));
    CreateRecipeProvider.GeneratedRecipe ENRICHED_SOUL_SOIL = this.create((ItemProviderEntry<? extends ItemLike>)CNBlocks.ENRICHED_SOUL_SOIL).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> Items.f_42686_)).viaShaped(b -> b.m_126127_(Character.valueOf('S'), (ItemLike)Blocks.f_50136_).m_126127_(Character.valueOf('O'), (ItemLike)Blocks.f_50080_).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42686_).m_126130_("SOS").m_126130_("ONO").m_126130_("SOS").m_271710_(true));
    CreateRecipeProvider.GeneratedRecipe ENRICHING_CAMPFIRE = this.create((ItemProviderEntry<? extends ItemLike>)CNBlocks.ENRICHING_CAMPFIRE).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CNBlocks.ENRICHED_SOUL_SOIL.get())).viaShaped(b -> b.m_126127_(Character.valueOf('E'), CNBlocks.ENRICHED_SOUL_SOIL).m_206416_(Character.valueOf('L'), ItemTags.f_13182_).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_126130_(" S ").m_126130_("SES").m_126130_("LLL").m_271710_(true));
    CreateRecipeProvider.GeneratedRecipe LEAD_COMPACTING = this.metalCompacting((List<ItemProviderEntry<? extends ItemLike>>)ImmutableList.of(CNItems.LEAD_NUGGET, CNItems.LEAD_INGOT, CNBlocks.LEAD_BLOCK), (List<Supplier<TagKey<Item>>>)ImmutableList.of(() -> CNTags.forgeItemTag("nuggets/lead"), () -> CNTags.forgeItemTag("ingots/lead"), () -> CNTags.forgeItemTag("storage_blocks/lead")));
    CreateRecipeProvider.GeneratedRecipe STEEL_COMPACTING = this.metalCompacting((List<ItemProviderEntry<? extends ItemLike>>)ImmutableList.of(CNItems.STEEL_NUGGET, CNItems.STEEL_INGOT, CNBlocks.STEEL_BLOCK), (List<Supplier<TagKey<Item>>>)ImmutableList.of(() -> CNTags.forgeItemTag("nuggets/steel"), () -> CNTags.forgeItemTag("ingots/steel"), () -> CNTags.forgeItemTag("storage_blocks/steel")));
    CreateRecipeProvider.GeneratedRecipe RAW_LEAD_BLOCK = this.create((ItemProviderEntry<? extends ItemLike>)CNBlocks.RAW_LEAD_BLOCK).unlockedByTag((Supplier<TagKey<Item>>)((Supplier)() -> CNTags.forgeItemTag("raw_materials/lead"))).viaShaped(b -> b.m_206416_(Character.valueOf('R'), CNTags.forgeItemTag("raw_materials/lead")).m_126130_("RRR").m_126130_("RRR").m_126130_("RRR").m_271710_(true));
    CreateRecipeProvider.GeneratedRecipe RAW_URANIUM_BLOCK = this.create((ItemProviderEntry<? extends ItemLike>)CNBlocks.RAW_URANIUM_BLOCK).unlockedByTag((Supplier<TagKey<Item>>)((Supplier)() -> CNTags.forgeItemTag("raw_materials/uranium"))).viaShaped(b -> b.m_206416_(Character.valueOf('R'), CNTags.forgeItemTag("raw_materials/uranium")).m_126130_("RRR").m_126130_("RRR").m_126130_("RRR").m_271710_(true));
    CreateRecipeProvider.GeneratedRecipe REACTOR_BLUEPRINT_ITEM = this.create((ItemProviderEntry<? extends ItemLike>)CNItems.REACTOR_BLUEPRINT).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CNBlocks.REACTOR_CONTROLLER.get())).viaShaped(b -> b.m_206416_(Character.valueOf('S'), CNTags.forgeItemTag("ingots/steel")).m_126127_(Character.valueOf('D'), (ItemLike)AllBlocks.DISPLAY_BOARD).m_126127_(Character.valueOf('P'), (ItemLike)AllItems.PRECISION_MECHANISM).m_126127_(Character.valueOf('E'), (ItemLike)AllItems.EMPTY_SCHEMATIC).m_126130_("SDS").m_126130_("SPS").m_126130_("SES").m_271710_(true));
    private final String CRAFTING_REACTOR = this.enterFolder("crafting/reactor");
    CreateRecipeProvider.GeneratedRecipe REINFORCED_GLASS = this.create((ItemProviderEntry<? extends ItemLike>)CNBlocks.REINFORCED_GLASS).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CNBlocks.REACTOR_CASING.get())).viaShaped(b -> b.m_206416_(Character.valueOf('G'), CNTags.forgeItemTag("glass")).m_206416_(Character.valueOf('S'), CNTags.forgeItemTag("ingots/lead")).m_126130_("SGS").m_126130_("GSG").m_126130_("SGS").m_271710_(true));
    private final String CRAFTING_ITEMS = this.enterFolder("crafting/items/armors");
    AntiRadiationArmorItem.DyeRecipeArmorList ANTI_RADIATION_HELMET = new AntiRadiationArmorItem.DyeRecipeArmorList(color -> this.create((ItemProviderEntry<? extends ItemLike>)CNItems.ANTI_RADIATION_HELMETS.get((DyeColor)color)).unlockedByTag((Supplier<TagKey<Item>>)((Supplier)() -> CNTags.CNItemTags.CLOTH.tag)).withCategory(RecipeCategory.COMBAT).viaShaped(i -> i.m_206416_(Character.valueOf('X'), CNTags.forgeItemTag("ingots/lead")).m_126127_(Character.valueOf('Y'), (ItemLike)ClothItem.Cloths.getByColor(color).get()).m_126127_(Character.valueOf('Z'), CNBlocks.REINFORCED_GLASS).m_126130_("YXY").m_126130_("XZX").m_271710_(true)));
    AntiRadiationArmorItem.DyeRecipeArmorList ANTI_RADIATION_CHESTPLATES = new AntiRadiationArmorItem.DyeRecipeArmorList(color -> this.create((ItemProviderEntry<? extends ItemLike>)CNItems.ANTI_RADIATION_CHESTPLATES.get((DyeColor)color)).unlockedByTag((Supplier<TagKey<Item>>)((Supplier)() -> CNTags.CNItemTags.CLOTH.tag)).withCategory(RecipeCategory.COMBAT).viaShaped(i -> i.m_206416_(Character.valueOf('X'), CNTags.forgeItemTag("ingots/lead")).m_126127_(Character.valueOf('Y'), (ItemLike)ClothItem.Cloths.getByColor(color).get()).m_126127_(Character.valueOf('Z'), CNItems.GRAPHITE_ROD).m_126130_("Y Y").m_126130_("XXX").m_126130_("ZXZ").m_271710_(true)));
    AntiRadiationArmorItem.DyeRecipeArmorList ANTI_RADIATION_LEGGINGS = new AntiRadiationArmorItem.DyeRecipeArmorList(color -> this.create((ItemProviderEntry<? extends ItemLike>)CNItems.ANTI_RADIATION_LEGGINGS.get((DyeColor)color)).unlockedByTag((Supplier<TagKey<Item>>)((Supplier)() -> CNTags.CNItemTags.CLOTH.tag)).withCategory(RecipeCategory.COMBAT).viaShaped(i -> i.m_206416_(Character.valueOf('X'), CNTags.forgeItemTag("ingots/lead")).m_126127_(Character.valueOf('Y'), (ItemLike)ClothItem.Cloths.getByColor(color).get()).m_126130_("YXY").m_126130_("X X").m_126130_("Y Y").m_271710_(true)));
    CreateRecipeProvider.GeneratedRecipe ANTI_RADIATION_BOOTS = this.create((ItemProviderEntry<? extends ItemLike>)CNItems.ANTI_RADIATION_BOOTS).unlockedByTag((Supplier<TagKey<Item>>)((Supplier)() -> CNTags.CNItemTags.CLOTH.tag)).withCategory(RecipeCategory.COMBAT).viaShaped(b -> b.m_206416_(Character.valueOf('X'), CNTags.forgeItemTag("ingots/lead")).m_126127_(Character.valueOf('Y'), ClothItem.Cloths.WHITE_CLOTH.getItem()).m_126130_("Y Y").m_126130_("X X").m_271710_(true));
    private final String BLAST_FURNACE = this.enterFolder("blast_furnace");
    CreateRecipeProvider.GeneratedRecipe URANIUM_ORE_TO_URANIUM_POWDER = this.blastFurnaceRecipeTags((Supplier<? extends ItemLike>)((Supplier)() -> () -> CNItems.RAW_URANIUM.get()), (Supplier<TagKey<Item>>)((Supplier)() -> CNTags.CNItemTags.URANIUM_ORES.tag), "_for_uranium_ore", 4);
    CreateRecipeProvider.GeneratedRecipe RAW_LEAD_ORES = this.blastFurnaceRecipeTags((Supplier<? extends ItemLike>)((Supplier)() -> () -> CNItems.LEAD_INGOT.get()), (Supplier<TagKey<Item>>)((Supplier)() -> CNTags.CNItemTags.LEAD_ORES.tag), "_for_lead_ore", 1);
    CreateRecipeProvider.GeneratedRecipe RAW_LEAD = this.blastFurnaceRecipeTags((Supplier<? extends ItemLike>)((Supplier)() -> CNItems.LEAD_INGOT.get()), (Supplier<TagKey<Item>>)((Supplier)() -> CNTags.forgeItemTag("raw_materials/lead")), "_for_raw_lead", 1);
    CreateRecipeProvider.GeneratedRecipe CRUSHED_RAW_LEAD_TO_LEAD_BLAST_FURNACE = this.blastFurnaceRecipe((Supplier<? extends ItemLike>)((Supplier)() -> CNItems.LEAD_INGOT.get()), (Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.CRUSHED_LEAD).get()), "_for_lead", 1);
    String currentFolder = "";

    String enterFolder(String foldedr) {
        this.currentFolder = foldedr;
        return this.currentFolder;
    }

    GeneratedRecipeBuilder create(Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ResourceLocation result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends ItemLike> result) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get()));
    }

    CreateRecipeProvider.GeneratedRecipe metalCompacting(List<ItemProviderEntry<? extends ItemLike>> variants, List<Supplier<TagKey<Item>>> ingredients) {
        CreateRecipeProvider.GeneratedRecipe result = null;
        int i = 0;
        while (i + 1 < variants.size()) {
            ItemProviderEntry<? extends ItemLike> currentEntry = variants.get(i);
            ItemProviderEntry<? extends ItemLike> nextEntry = variants.get(i + 1);
            Supplier<TagKey<Item>> currentIngredient = ingredients.get(i);
            Supplier<TagKey<Item>> nextIngredient = ingredients.get(i + 1);
            result = this.create(nextEntry).withSuffix("_from_compacting").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> currentEntry.get())).viaShaped(b -> b.m_126130_("###").m_126130_("###").m_126130_("###").m_206416_(Character.valueOf('#'), (TagKey)currentIngredient.get()));
            ++i;
        }
        return result;
    }

    CreateRecipeProvider.GeneratedRecipe blastFurnaceRecipe(Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> ingredient, String suffix, int count) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get())).withSuffix(suffix).returns(count).viaCooking((Supplier<? extends ItemLike>)((Supplier)() -> ingredient.get())).rewardXP(0.1f).inBlastFurnace();
    }

    CreateRecipeProvider.GeneratedRecipe blastFurnaceRecipeTags(Supplier<? extends ItemLike> result, Supplier<TagKey<Item>> ingredient, String suffix, int count) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get())).withSuffix(suffix).returns(count).viaCookingTag(ingredient).rewardXP(0.1f).inBlastFurnace();
    }

    CreateRecipeProvider.GeneratedRecipe smokerRecipe(Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> ingredient, String suffix, int count) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get())).withSuffix(suffix).returns(count).viaCooking((Supplier<? extends ItemLike>)((Supplier)() -> ingredient.get())).rewardXP(0.0f).inSmoker();
    }

    CreateRecipeProvider.GeneratedRecipe smokerRecipeTags(Supplier<? extends ItemLike> result, Supplier<TagKey<Item>> ingredient, String suffix, int count) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get())).withSuffix(suffix).returns(count).viaCookingTag(ingredient).rewardXP(0.0f).inSmoker();
    }

    CreateRecipeProvider.GeneratedRecipe furnaceRecipe(Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> ingredient, String suffix, int count) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get())).withSuffix(suffix).returns(count).viaCooking((Supplier<? extends ItemLike>)((Supplier)() -> ingredient.get())).rewardXP(0.1f).inFurnace();
    }

    CreateRecipeProvider.GeneratedRecipe furnaceRecipeTags(Supplier<? extends ItemLike> result, Supplier<TagKey<Item>> ingredient, String suffix, int count) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get())).withSuffix(suffix).returns(count).viaCookingTag(ingredient).rewardXP(0.1f).inFurnace();
    }

    public CNStandardRecipeGen(PackOutput output) {
        super(output);
    }

    class GeneratedRecipeBuilder {
        private String path;
        private String suffix;
        private Supplier<? extends ItemLike> result;
        private ResourceLocation compatDatagenOutput;
        private RecipeCategory category;
        private Supplier<ItemPredicate> unlockedBy;
        private int amount;

        private GeneratedRecipeBuilder(String path) {
            this.path = path;
            this.suffix = "";
            this.amount = 1;
            this.category = RecipeCategory.MISC;
        }

        public GeneratedRecipeBuilder(String path, Supplier<? extends ItemLike> result) {
            this(path);
            this.result = result;
        }

        public GeneratedRecipeBuilder(String path, ResourceLocation result) {
            this(path);
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)item.get()}).m_45077_();
            return this;
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_204145_((TagKey)tag.get()).m_45077_();
            return this;
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        GeneratedRecipeBuilder withCategory(RecipeCategory category) {
            this.category = category;
            return this;
        }

        CreateRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return CNStandardRecipeGen.this.register(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.m_246608_((RecipeCategory)this.category, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)CNStandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, this.createSimpleLocation(this.path));
            });
        }

        CreateRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return CNStandardRecipeGen.this.register(consumer -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.m_246517_((RecipeCategory)this.category, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)CNStandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, this.createSimpleLocation(this.path));
            });
        }

        CreateRecipeProvider.GeneratedRecipe viaNetheriteSmithing(Supplier<? extends Item> base, Supplier<Ingredient> upgradeMaterial) {
            this.withCategory(RecipeCategory.COMBAT);
            return CNStandardRecipeGen.this.register(consumer -> {
                SmithingTransformRecipeBuilder b = SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_265918_}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)base.get()}), (Ingredient)((Ingredient)upgradeMaterial.get()), (RecipeCategory)this.category, (Item)((ItemLike)this.result.get()).m_5456_());
                b.m_266439_("has_item", (CriterionTriggerInstance)CNStandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)base.get()}).m_45077_()}));
                b.m_266371_(consumer, this.createSimpleLocation(this.path));
            });
        }

        private ResourceLocation createSimpleLocation(String recipeType) {
            return CreateNuclear.asResource(recipeType + "/" + this.getRegistryName().m_135815_() + this.suffix);
        }

        private ResourceLocation createLocation(String recipeType) {
            return CreateNuclear.asResource(recipeType + "/" + this.path + "/" + this.getRegistryName().m_135815_() + this.suffix);
        }

        private ResourceLocation getRegistryName() {
            return this.compatDatagenOutput == null ? CatnipServices.REGISTRIES.getKeyOrThrow(((ItemLike)this.result.get()).m_5456_()) : this.compatDatagenOutput;
        }

        GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends ItemLike> item) {
            return this.unlockedBy(item).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)item.get()})));
        }

        GeneratedCookingRecipeBuilder viaCookingTag(Supplier<TagKey<Item>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.m_204132_((TagKey)((TagKey)tag.get()))));
        }

        GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<Ingredient> ingredient) {
            return new GeneratedCookingRecipeBuilder(ingredient);
        }

        class GeneratedCookingRecipeBuilder {
            private Supplier<Ingredient> ingredient;
            private float exp;
            private int cookingTime;
            private final RecipeSerializer<? extends AbstractCookingRecipe> FURNACE = RecipeSerializer.f_44091_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> SMOKER = RecipeSerializer.f_44093_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> BLAST = RecipeSerializer.f_44092_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> CAMPFIRE = RecipeSerializer.f_44094_;

            GeneratedCookingRecipeBuilder(Supplier<Ingredient> ingredient) {
                this.ingredient = ingredient;
                this.cookingTime = 200;
                this.exp = 0.0f;
            }

            GeneratedCookingRecipeBuilder forDuration(int duration) {
                this.cookingTime = duration;
                return this;
            }

            GeneratedCookingRecipeBuilder rewardXP(float xp) {
                this.exp = xp;
                return this;
            }

            CreateRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            CreateRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                return this.create(this.FURNACE, builder, 1.0f);
            }

            CreateRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            CreateRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                this.create(this.CAMPFIRE, builder, 3.0f);
                return this.create(this.SMOKER, builder, 0.5f);
            }

            CreateRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            CreateRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                return this.create(this.BLAST, builder, 0.5f);
            }

            private CreateRecipeProvider.GeneratedRecipe create(RecipeSerializer<? extends AbstractCookingRecipe> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, float cookingTimeModifier) {
                return CNStandardRecipeGen.this.register(consumer -> {
                    boolean isOtherMod = GeneratedRecipeBuilder.this.compatDatagenOutput != null;
                    SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.m_247607_((Ingredient)((Ingredient)this.ingredient.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)(isOtherMod ? Items.f_42329_ : (ItemLike)GeneratedRecipeBuilder.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (RecipeSerializer)serializer));
                    if (GeneratedRecipeBuilder.this.unlockedBy != null) {
                        b.m_126132_("has_item", (CriterionTriggerInstance)CNStandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)GeneratedRecipeBuilder.this.unlockedBy.get()}));
                    }
                    b.m_126140_(result -> consumer.accept(isOtherMod ? new ModdedCookingRecipeResult((FinishedRecipe)result, GeneratedRecipeBuilder.this.compatDatagenOutput, null) : result), GeneratedRecipeBuilder.this.createSimpleLocation(CatnipServices.REGISTRIES.getKeyOrThrow(serializer).m_135815_()));
                });
            }
        }
    }

    private record ModdedCookingRecipeResult(FinishedRecipe wrapped, ResourceLocation outputOverride, List<ICondition> conditions) implements FinishedRecipe
    {
        public ResourceLocation m_6445_() {
            return this.wrapped.m_6445_();
        }

        public RecipeSerializer<?> m_6637_() {
            return this.wrapped.m_6637_();
        }

        public JsonObject m_5860_() {
            return this.wrapped.m_5860_();
        }

        public ResourceLocation m_6448_() {
            return this.wrapped.m_6448_();
        }

        public void m_7917_(JsonObject object) {
            this.wrapped.m_7917_(object);
            object.addProperty("result", this.outputOverride.toString());
            JsonArray conds = new JsonArray();
            this.conditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            object.add("conditions", (JsonElement)conds);
        }
    }
}

