/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SearchComponentWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;

public class FluidConfigurator
extends ValueConfigurator<Fluid>
implements SearchComponentWidget.IWidgetSearch<Fluid> {
    protected SearchComponentWidget<Fluid> searchComponent;
    protected ImageWidget image;

    public FluidConfigurator(String name, Supplier<Fluid> supplier, Consumer<Fluid> onUpdate, @Nonnull Fluid defaultValue, boolean forceUpdate) {
        super(name, supplier, onUpdate, defaultValue, forceUpdate);
        if (this.value == null) {
            this.value = defaultValue;
        }
    }

    @Override
    protected void onValueUpdate(Fluid newValue) {
        if (newValue == null) {
            newValue = (Fluid)this.defaultValue;
        }
        if (this.value == newValue) {
            return;
        }
        super.onValueUpdate(newValue);
        this.searchComponent.setCurrent(this.value == null ? (Fluid)this.defaultValue : (Fluid)this.value);
    }

    @Override
    public void init(int width) {
        super.init(width);
        this.image = new ImageWidget(this.leftWidth, 2, width - this.leftWidth - 3 - this.rightWidth, 10, ColorPattern.T_GRAY.rectTexture().setRadius(5.0f));
        this.addWidget(this.image);
        this.image.setDraggingConsumer(o -> o instanceof Fluid || o instanceof FluidStack, o -> this.image.setImage(ColorPattern.GREEN.rectTexture().setRadius(5.0f)), o -> this.image.setImage(ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)), o -> {
            if (o instanceof FluidStack) {
                FluidStack fluidStack = (FluidStack)o;
                this.onValueUpdate(fluidStack.getFluid());
                this.updateValue();
            } else if (o instanceof Fluid) {
                Fluid fluid = (Fluid)o;
                this.onValueUpdate(fluid);
                this.updateValue();
            }
            this.image.setImage(ColorPattern.T_GRAY.rectTexture().setRadius(5.0f));
        });
        this.searchComponent = new SearchComponentWidget<Fluid>(this.leftWidth + 3, 2, width - this.leftWidth - 6 - this.rightWidth, 10, this);
        this.addWidget(this.searchComponent);
        this.searchComponent.setIconProvider(fluid -> new ItemStackTexture(fluid.m_6859_()));
        this.searchComponent.setShowUp(true);
        this.searchComponent.setCapacity(5);
        this.searchComponent.setCurrent((Fluid)this.value);
        TextFieldWidget textFieldWidget = this.searchComponent.textFieldWidget;
        textFieldWidget.setClientSideWidget();
        textFieldWidget.setBordered(false);
    }

    @Override
    public String resultDisplay(Fluid fluid) {
        return BuiltInRegistries.f_257020_.m_7981_((Object)fluid).toString();
    }

    @Override
    public void selectResult(Fluid value) {
        this.onValueUpdate(value);
        this.updateValue();
    }

    @Override
    public void search(String word, Consumer<Fluid> find) {
        String wordLower = word.toLowerCase();
        for (Map.Entry entry : BuiltInRegistries.f_257020_.m_6579_()) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            Fluid fluid = (Fluid)entry.getValue();
            ResourceLocation id = ((ResourceKey)entry.getKey()).m_135782_();
            if (!id.toString().contains(wordLower)) continue;
            find.accept(fluid);
        }
    }
}

