/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.data.resource;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;

public final class StaticResource<T> {
    public static StaticResource EMPTY = new StaticResource();
    private final Resource<T> resource;
    final Map<File, T> staticResources = new LinkedHashMap<File, T>();
    final Map<File, Long> staticResourcesLastModified = new LinkedHashMap<File, Long>();
    private boolean isStaticResourceLoaded = false;

    public static <T> StaticResource<T> empty() {
        return EMPTY;
    }

    private StaticResource() {
        this.resource = null;
    }

    public StaticResource(Resource<T> resource) {
        this.resource = resource;
        if (!resource.supportStaticResource()) {
            throw new IllegalArgumentException("Resource " + String.valueOf(resource) + " does not support static resource");
        }
    }

    public boolean loadAndUpdateStaticResource() {
        if (this.resource == null) {
            return false;
        }
        boolean changed = false;
        HashSet<File> found = new HashSet<File>();
        File[] files = this.resource.getStaticLocation().listFiles();
        if (files != null) {
            for (File file2 : files) {
                if (!file2.isFile() || !file2.getName().endsWith(this.resource.getStaticResourceSuffix())) continue;
                if (this.staticResources.containsKey(file2)) {
                    if (this.staticResourcesLastModified.get(file2).longValue() != file2.lastModified()) {
                        T res = this.readResourceFromFile(file2);
                        if (res == null) continue;
                        this.staticResources.put(file2, res);
                        this.staticResourcesLastModified.put(file2, file2.lastModified());
                        changed = true;
                        found.add(file2);
                        continue;
                    }
                    found.add(file2);
                    continue;
                }
                T resource = this.readResourceFromFile(file2);
                if (resource == null) continue;
                this.staticResources.put(file2, resource);
                this.staticResourcesLastModified.put(file2, file2.lastModified());
                changed = true;
                found.add(file2);
            }
        }
        if (found.size() != this.staticResources.size()) {
            HashSet<File> removed = new HashSet<File>(this.staticResources.keySet());
            removed.removeAll(found);
            removed.forEach(file -> {
                this.staticResourcesLastModified.remove(file);
                this.staticResources.remove(file);
            });
            changed = true;
        }
        this.isStaticResourceLoaded = true;
        return changed;
    }

    @Nullable
    private T readResourceFromFile(File file) {
        try {
            CompoundTag fileData = NbtIo.m_128953_((File)file);
            if (fileData != null && fileData.m_128461_("type").equals(this.resource.name())) {
                return this.resource.deserialize(fileData.m_128423_("data"));
            }
            LDLib.LOGGER.error("Failed to load static resource file {} from {}: ", (Object)file, (Object)this);
        }
        catch (IOException e) {
            LDLib.LOGGER.error("Failed to load static resource file {} from {}: ", new Object[]{file, this, e});
        }
        return null;
    }

    public boolean isStaticResourceLoaded() {
        return this.isStaticResourceLoaded;
    }
}

