/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import net.minecraft.core.Direction;

@LDLRegister(name="direction", group="graph_processor.node.minecraft.data")
public class DirectionNode
extends BaseNode {
    @InputPort
    public Object in = null;
    @OutputPort
    public Direction out = null;
    @Configurable(showName=false)
    public Direction internalValue = Direction.NORTH;

    @Override
    public void process() {
        if (this.in == null) {
            this.out = this.internalValue;
        } else {
            Object object = this.in;
            if (object instanceof Direction) {
                Direction direction;
                this.out = direction = (Direction)object;
            } else {
                object = this.in;
                if (object instanceof Number) {
                    Number number = (Number)object;
                    this.out = Direction.values()[number.intValue() % Direction.values().length];
                } else {
                    try {
                        this.out = Direction.valueOf((String)this.in.toString().toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        this.out = null;
                    }
                }
            }
        }
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        for (NodePort port : this.getInputPorts()) {
            if (!port.fieldName.equals("in") || port.getEdges().isEmpty()) continue;
            return;
        }
        super.buildConfigurator(father);
    }
}

