/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.json.factory;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateTypeAdapterFactory
implements TypeAdapterFactory {
    public static final BlockStateTypeAdapterFactory INSTANCE = new BlockStateTypeAdapterFactory();

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (BlockState.class.isAssignableFrom(type.getRawType())) {
            return new IBlockStateTypeAdapter(gson);
        }
        return null;
    }

    private static final class IBlockStateTypeAdapter
    extends TypeAdapter<BlockState> {
        private final Gson gson;

        private IBlockStateTypeAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, BlockState value) {
            if (value == null) {
                this.gson.toJson((JsonElement)JsonNull.INSTANCE, out);
                return;
            }
            BuiltInRegistries.f_256975_.m_7981_((Object)value.m_60734_());
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", BuiltInRegistries.f_256975_.m_7981_((Object)value.m_60734_()).toString());
            jsonObject.addProperty("meta", (Number)value.m_60734_().m_49965_().m_61056_().indexOf((Object)value));
            this.gson.toJson((JsonElement)jsonObject, out);
        }

        public BlockState read(JsonReader in) {
            JsonElement jsonElement = (JsonElement)this.gson.fromJson(in, JsonElement.class);
            if (jsonElement.isJsonNull()) {
                return null;
            }
            ResourceLocation id = new ResourceLocation(jsonElement.getAsJsonObject().get("id").getAsString());
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(id);
            if (block == Blocks.f_50016_ && !id.equals((Object)new ResourceLocation("air"))) {
                return null;
            }
            if (jsonElement.getAsJsonObject().has("meta")) {
                int meta = jsonElement.getAsJsonObject().get("meta").getAsInt();
                return block.m_49965_().m_61056_().size() > meta ? (BlockState)block.m_49965_().m_61056_().get(meta) : block.m_49966_();
            }
            return block.m_49966_();
        }
    }
}

