/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.accessor.ManagedAccessor;
import com.lowdragmc.lowdraglib.syncdata.managed.IManagedVar;
import com.lowdragmc.lowdraglib.syncdata.payload.EnumValuePayload;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.PrimitiveTypedPayload;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.util.StringRepresentable;

public class EnumAccessor
extends ManagedAccessor {
    private static final WeakHashMap<Class<? extends Enum<?>>, Enum<?>[]> enumCache = new WeakHashMap();
    private static final WeakHashMap<Class<? extends Enum<?>>, Map<String, Enum<?>>> enumNameCache = new WeakHashMap();

    public static <T extends Enum<T>> T getEnum(Class<T> type, String name) {
        Map values = enumNameCache.computeIfAbsent(type, t -> {
            WeakHashMap<String, Enum> map = new WeakHashMap<String, Enum>();
            for (Enum value : (Enum[])t.getEnumConstants()) {
                String enumName = EnumAccessor.getEnumName(value);
                map.put(enumName, value);
            }
            return map;
        });
        Enum value = (Enum)values.get(name);
        if (value == null) {
            return null;
        }
        return (T)((Enum)type.cast(value));
    }

    public static String getEnumName(Enum<?> enumValue) {
        if (enumValue instanceof StringRepresentable) {
            StringRepresentable provider = (StringRepresentable)enumValue;
            return provider.m_7912_();
        }
        return enumValue.name();
    }

    public static <T extends Enum<T>> T getEnum(Class<T> type, int ordinal) {
        Enum[] values = enumCache.computeIfAbsent(type, Class::getEnumConstants);
        if (ordinal < 0 || ordinal >= values.length) {
            throw new IllegalArgumentException("Invalid ordinal for enum type " + type.getName() + ": " + ordinal);
        }
        return (T)((Enum)type.cast(values[ordinal]));
    }

    @Override
    public boolean hasPredicate() {
        return true;
    }

    @Override
    public boolean test(Class<?> type) {
        return type.isEnum();
    }

    @Override
    public ITypedPayload<?> readManagedField(AccessorOp op, IManagedVar<?> field) {
        if (!field.getType().isEnum()) {
            throw new IllegalArgumentException("Field is not an enum");
        }
        Object value = field.value();
        if (value != null) {
            Enum enumVal = (Enum)value;
            String name = EnumAccessor.getEnumName(enumVal);
            int ordinal = enumVal.ordinal();
            return EnumValuePayload.of(name, ordinal);
        }
        return PrimitiveTypedPayload.ofNull();
    }

    @Override
    public void writeManagedField(AccessorOp op, IManagedVar<?> field, ITypedPayload<?> payload) {
        PrimitiveTypedPayload primitive;
        if (payload instanceof PrimitiveTypedPayload && (primitive = (PrimitiveTypedPayload)payload).isNull()) {
            field.set(null);
            return;
        }
        if (!field.getType().isEnum()) {
            throw new IllegalArgumentException("Field is not an enum");
        }
        if (!(payload instanceof EnumValuePayload)) {
            throw new IllegalArgumentException("Payload is not an enum value");
        }
        EnumValuePayload enumValue = (EnumValuePayload)payload;
        IManagedVar<?> enumField = field;
        int ordinal = ((EnumValuePayload.Payload)enumValue.getPayload()).ordinal;
        String name = ((EnumValuePayload.Payload)enumValue.getPayload()).name;
        Object value = ordinal >= 0 ? EnumAccessor.getEnum(field.getType(), ordinal) : EnumAccessor.getEnum(field.getType(), name);
        if (value == null) {
            value = EnumAccessor.getEnum(field.getType(), 0);
        }
        if (value == null) {
            throw new IllegalArgumentException("Invalid enum value %s (%d) for field %s".formatted(name, ordinal, field));
        }
        enumField.set(value);
    }
}

