/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import net.minecraftforge.common.util.NonNullFunction;

public class UnmodifiableChildrenIterator<T, P>
extends AbstractIterator<T> {
    private final Iterator<P> _parent;
    private final NonNullFunction<P, Iterator<T>> _mapper;
    private Iterator<T> _cursor;

    public UnmodifiableChildrenIterator(Iterator<P> parent, NonNullFunction<P, Iterator<T>> childProvider) {
        Preconditions.checkNotNull(parent, (Object)"Parent must not be null");
        Preconditions.checkNotNull(childProvider, (Object)"Child provider must not be null");
        this._parent = parent;
        this._mapper = childProvider;
    }

    protected T computeNext() {
        if (null == this._cursor || !this._cursor.hasNext()) {
            this._cursor = null;
            while (this._parent.hasNext()) {
                Iterator newCursor = (Iterator)this._mapper.apply(this._parent.next());
                if (!newCursor.hasNext()) continue;
                this._cursor = newCursor;
                break;
            }
            if (null == this._cursor) {
                return (T)this.endOfData();
            }
        }
        return this._cursor.next();
    }
}

