/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class MobHeadShadersManager
extends SimpleJsonResourceReloadListener {
    public static final MobHeadShadersManager INSTANCE = new MobHeadShadersManager();
    private final Map<Item, String> effects = new HashMap<Item, String>();
    private final Map<EntityType<?>, String> entityEffects = new HashMap();
    private final Set<String> myShaders = new HashSet<String>();
    private String lastAppliedShader = null;

    public MobHeadShadersManager() {
        super(new Gson(), "mob_head_effects");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.effects.clear();
        this.entityEffects.clear();
        this.myShaders.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            MobHeadEffect effect = (MobHeadEffect)MobHeadEffect.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).getOrThrow(false, s -> Supplementaries.LOGGER.error("Failed to parse mob head effect: {}", s));
            String shaderPath = effect.getShaderPath();
            for (Item item : effect.items) {
                if (item == Items.f_41852_) {
                    throw new IllegalArgumentException("Mob head effect cannot have AIR item: " + String.valueOf(effect.shader));
                }
                this.effects.put(item, shaderPath);
            }
            for (EntityType entityType : effect.entityTypes) {
                this.entityEffects.put(entityType, shaderPath);
            }
            this.myShaders.add(shaderPath);
        }
        this.myShaders.add(ClientRegistry.BARBARIC_RAGE_SHADER);
    }

    @Nullable
    public String getShaderForItem(Item item) {
        return this.effects.get(item);
    }

    @Nullable
    public String getShaderForEntity(EntityType<?> entityType) {
        return this.entityEffects.get(entityType);
    }

    public void applyMobHeadShaders(Player p, Minecraft mc) {
        if (ClientConfigs.Tweaks.MOB_HEAD_EFFECTS.get().booleanValue()) {
            String rendererShader;
            GameRenderer renderer = Minecraft.m_91087_().f_91063_;
            String string = rendererShader = renderer.f_109050_ == null ? null : renderer.f_109050_.m_110022_();
            if (rendererShader != null && !this.myShaders.contains(rendererShader)) {
                return;
            }
            if (p.m_5833_()) {
                if (rendererShader != null && this.lastAppliedShader != null) {
                    renderer.m_109086_();
                    this.lastAppliedShader = null;
                }
                return;
            }
            if (rendererShader == null && this.lastAppliedShader != null) {
                this.lastAppliedShader = null;
            }
            ItemStack stack = p.m_6844_(EquipmentSlot.HEAD);
            if (CompatHandler.QUARK && QuarkCompat.shouldHideOverlay(stack)) {
                return;
            }
            Item item = stack.m_41720_();
            String newShader = mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON ? this.getShaderForItem(item) : null;
            if (newShader == null && this.shouldHaveGoatedEffect(p, item)) {
                newShader = ClientRegistry.BARBARIC_RAGE_SHADER;
            }
            if (!(newShader == null || newShader.equals(rendererShader) && renderer.f_109053_)) {
                renderer.m_109128_(ResourceLocation.m_135820_((String)newShader));
                this.lastAppliedShader = newShader;
            } else if (rendererShader != null && newShader == null) {
                renderer.m_109086_();
                this.lastAppliedShader = null;
            }
        }
    }

    private boolean shouldHaveGoatedEffect(Player p, Item item) {
        return CompatHandler.GOATED && item == CompatObjects.BARBARIC_HELMET.get() && p.m_21223_() < 5.0f;
    }

    @Nullable
    public ResourceLocation getSpectatorShaders(Entity entity) {
        Rabbit e;
        if (entity == null) {
            return null;
        }
        String s = this.getShaderForEntity(entity.m_6095_());
        if (s != null) {
            return ResourceLocation.m_135820_((String)s);
        }
        if (entity instanceof AbstractSkeleton) {
            return ClientRegistry.BLACK_AND_WHITE_SHADER;
        }
        if (entity instanceof Zombie) {
            return ClientRegistry.VANILLA_DESATURATE_SHADER;
        }
        if (entity instanceof Rabbit && (e = (Rabbit)entity).m_28554_() == Rabbit.Variant.EVIL) {
            return ClientRegistry.RAGE_SHADER;
        }
        if (entity instanceof Piglin) {
            return ClientRegistry.GLITTER_SHADER;
        }
        if (entity instanceof WitherBoss) {
            return ClientRegistry.BLACK_AND_WHITE_SHADER;
        }
        return null;
    }

    private record MobHeadEffect(List<Item> items, List<EntityType<?>> entityTypes, ResourceLocation shader) {
        public static final Codec<MobHeadEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_194605_().listOf().optionalFieldOf("items", List.of()).forGetter(MobHeadEffect::items), (App)BuiltInRegistries.f_256780_.m_194605_().listOf().optionalFieldOf("entity_types", List.of()).forGetter(MobHeadEffect::entityTypes), (App)ResourceLocation.f_135803_.fieldOf("shader").forGetter(MobHeadEffect::shader)).apply((Applicative)instance, MobHeadEffect::new));

        public String getShaderPath() {
            return this.shader.m_247266_(p -> "shaders/post/" + p + ".json").toString();
        }
    }
}

