/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.RecipeSerializerRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.util.TheurgyExtraCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class CatalysationRecipe
implements Recipe<RecipeWrapper> {
    public static final int DEFAULT_MERCURY_FLUX_PER_TICK = 20;
    public static final Codec<CatalysationRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TheurgyExtraCodecs.INGREDIENT.fieldOf("ingredient").forGetter(r -> r.ingredient), (App)Codec.INT.fieldOf("totalMercuryFlux").forGetter(r -> r.totalMercuryFlux), (App)Codec.INT.fieldOf("mercuryFluxPerTick").forGetter(r -> r.mercuryFluxPerTick)).apply((Applicative)instance, CatalysationRecipe::new));
    protected final Ingredient ingredient;
    protected final int mercuryFluxPerTick;
    protected final int totalMercuryFlux;
    protected ResourceLocation id;

    public CatalysationRecipe(Ingredient ingredient, int totalMercuryFlux, int mercuryFluxPerTick) {
        this.ingredient = ingredient;
        this.totalMercuryFlux = totalMercuryFlux;
        this.mercuryFluxPerTick = mercuryFluxPerTick;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.CATALYSATION.get();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getMercuryFluxPerTick() {
        return this.mercuryFluxPerTick;
    }

    public int getTotalMercuryFlux() {
        return this.totalMercuryFlux;
    }

    public boolean matches(RecipeWrapper pContainer, Level pLevel) {
        ItemStack stack = pContainer.m_8020_(0);
        return this.ingredient.test(stack);
    }

    public ItemStack assemble(RecipeWrapper pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.ingredient});
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ItemRegistry.MERCURY_CATALYST.get());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerRegistry.CATALYSATION.get();
    }

    public static class Serializer
    implements RecipeSerializer<CatalysationRecipe> {
        public CatalysationRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            CatalysationRecipe recipe = (CatalysationRecipe)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)pJson).getOrThrow(false, s -> {
                throw new JsonParseException(s);
            });
            recipe.id = pRecipeId;
            return recipe;
        }

        public CatalysationRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            CatalysationRecipe recipe = (CatalysationRecipe)pBuffer.m_271872_(CODEC);
            recipe.id = pRecipeId;
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf pBuffer, CatalysationRecipe pRecipe) {
            pBuffer.m_272073_(CODEC, (Object)pRecipe);
        }
    }
}

