/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.gettingstarted.transmutation;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

public class ConvertToOtherTypeEntry
extends EntryProvider {
    public static final String ENTRY_ID = "convert_to_other_type";

    public ConvertToOtherTypeEntry(CategoryProvider parent) {
        super(parent);
    }

    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("Transmutation");
        this.pageText("Transmutation is the conversion of one type of matter into another (e.g. gems into metals).\n\\\n\\\nThus, transmutation deals with the already discussed challenge of Sulfur resisting significant change.\n");
        this.page("intro2", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("Transmutation");
        this.pageText("Due to inherent differences of the types of matter there is often a loss or gain, depending on the direction of conversion.\\\nGenerally, 2 metals convert into 1 gem and vice versa.\nSimilarly, 2 other minerals convert into 1 metal and vice versa.\nConsequently 4 other minerals convert into 1 gem and vice versa.\n");
        this.page("process", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("Process");
        this.pageText("Transmutation consists of three steps.\n\\\n\\\nFirst, the Sulfur to be transformed is fermented alchemically into Niter (e.g. Quartz Sulfur into Common Gems Niter).\\\nThen that malleable Niter can be reformed into another Niter of the desired type (e.g. Common Gems Niter into Common Metals Niter).\n");
        this.page("process2", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("Process");
        this.pageText("Finally that Niter can be reformed again into the desired Sulfur (e.g. Common Metals Niter into Iron Sulfur).\n");
        this.page("limitations", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("Limitations");
        this.pageText("While fermentation into niter overcomes the limitation of *type*, the limitation of *tier* (Abundant, Common, Rare, ... ) remains.\n\\\nConversion of Iron into Gold remains out of reach just yet.\n\\\n\\\nThis process will be tackled after you have succeeded in transmutation.\n");
        this.page("instructions", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("Instructions");
        this.pageText("The following entries will guide you through the conversion of {0} into {1}, *assuming you already obtained at least one Sulfur of each*.\n\\\n\\\nThe instructions also apply to all other conversions within the same tier.\n", new Object[]{this.itemLink("Alchemical Sulfur: Quartz", (ItemLike)SulfurRegistry.QUARTZ.get()), this.itemLink("Alchemical Sulfur: Iron", (ItemLike)SulfurRegistry.IRON.get())});
    }

    protected String entryName() {
        return "Replication by Transmutation";
    }

    protected String entryDescription() {
        return "Obtaining more of an item by converting items of the same tier, but another type";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return Pair.of((Object)0, (Object)2);
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ResourceLocation)this.modLoc("textures/gui/book/convert_types.png"));
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

