/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.model;

import com.klikli_dev.theurgy.TheurgyConstants;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.SaltRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class TheurgyItemModelProvider
extends ItemModelProvider {
    public TheurgyItemModelProvider(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super(packOutput, "theurgy", existingFileHelper);
    }

    protected String name(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
    }

    private ItemModelBuilder registerAlchemicalSalt(String name) {
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/alchemical_salt")));
    }

    private ItemModelBuilder registerItemGenerated(String name) {
        return this.registerItemGenerated(name, name);
    }

    private ItemModelBuilder registerItemGenerated(String name, String texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.modLoc("item/" + texture));
    }

    private void registerItemHandheld(String name) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", this.modLoc("item/" + name));
    }

    private void registerItemBuiltinEntity(String name) {
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"));
    }

    private void registerDivinationRod(Item divinationRodItem) {
        ItemModelBuilder variant0 = this.registerItemGenerated("item/" + this.name(divinationRodItem) + "/0", this.name(divinationRodItem) + "/divination_rod_0");
        ItemModelBuilder variant1 = this.registerItemGenerated("item/" + this.name(divinationRodItem) + "/1", this.name(divinationRodItem) + "/divination_rod_1");
        ItemModelBuilder variant2 = this.registerItemGenerated("item/" + this.name(divinationRodItem) + "/2", this.name(divinationRodItem) + "/divination_rod_2");
        ItemModelBuilder variant3 = this.registerItemGenerated("item/" + this.name(divinationRodItem) + "/3", this.name(divinationRodItem) + "/divination_rod_3");
        ItemModelBuilder variant4 = this.registerItemGenerated("item/" + this.name(divinationRodItem) + "/4", this.name(divinationRodItem) + "/divination_rod_4");
        ItemModelBuilder variant5 = this.registerItemGenerated("item/" + this.name(divinationRodItem) + "/5", this.name(divinationRodItem) + "/divination_rod_5");
        ItemModelBuilder variant6 = this.registerItemGenerated("item/" + this.name(divinationRodItem) + "/6", this.name(divinationRodItem) + "/divination_rod_6");
        ItemModelBuilder variant7 = this.registerItemGenerated("item/" + this.name(divinationRodItem) + "/7", this.name(divinationRodItem) + "/divination_rod_7");
        ItemModelBuilder searchingVariant = this.registerItemGenerated("item/" + this.name(divinationRodItem) + "/searching", this.name(divinationRodItem) + "/divination_rod_searching");
        String name = this.name(divinationRodItem);
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)variant0)).override().model((ModelFile)variant7).predicate(TheurgyConstants.ItemProperty.DIVINATION_DISTANCE, 0.0f).end().override().model((ModelFile)variant6).predicate(TheurgyConstants.ItemProperty.DIVINATION_DISTANCE, 1.0f).end().override().model((ModelFile)variant5).predicate(TheurgyConstants.ItemProperty.DIVINATION_DISTANCE, 2.0f).end().override().model((ModelFile)variant4).predicate(TheurgyConstants.ItemProperty.DIVINATION_DISTANCE, 3.0f).end().override().model((ModelFile)variant3).predicate(TheurgyConstants.ItemProperty.DIVINATION_DISTANCE, 4.0f).end().override().model((ModelFile)variant2).predicate(TheurgyConstants.ItemProperty.DIVINATION_DISTANCE, 5.0f).end().override().model((ModelFile)variant1).predicate(TheurgyConstants.ItemProperty.DIVINATION_DISTANCE, 6.0f).end().override().model((ModelFile)variant0).predicate(TheurgyConstants.ItemProperty.DIVINATION_DISTANCE, 7.0f).end().override().model((ModelFile)searchingVariant).predicate(TheurgyConstants.ItemProperty.DIVINATION_DISTANCE, 8.0f).end();
    }

    protected void registerSulfurs() {
        SulfurRegistry.SULFURS.getEntries().stream().map(RegistryObject::get).map(AlchemicalSulfurItem.class::cast).forEach(sulfur -> {
            if (sulfur.useAutomaticIconRendering) {
                this.registerItemBuiltinEntity(this.name((Item)sulfur));
            }
        });
        this.registerItemGenerated(this.name((Item)ItemRegistry.GEMS_ABUNDANT_ICON.get()), "sulfurs/gems_abundant");
        this.registerItemGenerated(this.name((Item)ItemRegistry.GEMS_COMMON_ICON.get()), "sulfurs/gems_common");
        this.registerItemGenerated(this.name((Item)ItemRegistry.GEMS_RARE_ICON.get()), "sulfurs/gems_rare");
        this.registerItemGenerated(this.name((Item)ItemRegistry.GEMS_PRECIOUS_ICON.get()), "sulfurs/gems_precious");
        this.registerItemGenerated(this.name((Item)ItemRegistry.METALS_ABUNDANT_ICON.get()), "sulfurs/metals_abundant");
        this.registerItemGenerated(this.name((Item)ItemRegistry.METALS_COMMON_ICON.get()), "sulfurs/metals_common");
        this.registerItemGenerated(this.name((Item)ItemRegistry.METALS_RARE_ICON.get()), "sulfurs/metals_rare");
        this.registerItemGenerated(this.name((Item)ItemRegistry.METALS_PRECIOUS_ICON.get()), "sulfurs/metals_precious");
        this.registerItemGenerated(this.name((Item)ItemRegistry.OTHER_MINERALS_ABUNDANT_ICON.get()), "sulfurs/other_minerals_abundant");
        this.registerItemGenerated(this.name((Item)ItemRegistry.OTHER_MINERALS_COMMON_ICON.get()), "sulfurs/other_minerals_common");
        this.registerItemGenerated(this.name((Item)ItemRegistry.OTHER_MINERALS_RARE_ICON.get()), "sulfurs/other_minerals_rare");
        this.registerItemGenerated(this.name((Item)ItemRegistry.OTHER_MINERALS_PRECIOUS_ICON.get()), "sulfurs/other_minerals_precious");
    }

    protected void registerSalts() {
        this.registerItemGenerated("alchemical_salt");
        SaltRegistry.SALTS.getEntries().stream().map(RegistryObject::get).forEach(salt -> this.registerAlchemicalSalt(this.name((Item)salt)));
    }

    protected void registerModels() {
        this.registerItemGenerated(this.name((Item)ItemRegistry.THE_HERMETICA_ICON.get()), "the_hermetica");
        this.registerItemGenerated(this.name((Item)ItemRegistry.EMPTY_JAR_ICON.get()), "empty_jar");
        this.registerItemGenerated(this.name((Item)ItemRegistry.EMPTY_JAR_IRON_BAND_ICON.get()), "empty_jar_iron_band");
        this.registerItemGenerated(this.name((Item)ItemRegistry.EMPTY_JAR_LABELED_ICON.get()), "empty_jar_labeled");
        this.registerItemGenerated(this.name((Item)ItemRegistry.EMPTY_CERAMIC_JAR_ICON.get()), "empty_ceramic_jar");
        this.registerItemGenerated(this.name((Item)ItemRegistry.EMPTY_CERAMIC_JAR_LABELED_ICON.get()), "empty_ceramic_jar_labeled");
        this.registerItemGenerated(this.name((Item)ItemRegistry.JAR_LABEL_ICON.get()), "jar_label");
        this.registerItemGenerated(this.name((Item)ItemRegistry.JAR_LABEL_FRAME_ABUNDANT_ICON.get()), "jar_label_frame_abundant");
        this.registerItemGenerated(this.name((Item)ItemRegistry.JAR_LABEL_FRAME_COMMON_ICON.get()), "jar_label_frame_common");
        this.registerItemGenerated(this.name((Item)ItemRegistry.JAR_LABEL_FRAME_RARE_ICON.get()), "jar_label_frame_rare");
        this.registerItemGenerated(this.name((Item)ItemRegistry.JAR_LABEL_FRAME_PRECIOUS_ICON.get()), "jar_label_frame_precious");
        this.registerSulfurs();
        this.registerSalts();
        this.registerItemGenerated(this.name((Item)ItemRegistry.MERCURY_SHARD.get()));
        this.registerItemGenerated(this.name((Item)ItemRegistry.MERCURY_CRYSTAL.get()));
        this.registerItemGenerated(this.name((Item)ItemRegistry.SAL_AMMONIAC_CRYSTAL.get()));
        this.registerItemGenerated(this.name((Item)ItemRegistry.PURIFIED_GOLD.get()));
        this.registerDivinationRod((Item)ItemRegistry.DIVINATION_ROD_T1.get());
        this.registerDivinationRod((Item)ItemRegistry.DIVINATION_ROD_T2.get());
        this.registerDivinationRod((Item)ItemRegistry.DIVINATION_ROD_T3.get());
        this.registerDivinationRod((Item)ItemRegistry.DIVINATION_ROD_T4.get());
        this.registerDivinationRod((Item)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_ABUNDANT.get());
        this.registerDivinationRod((Item)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_COMMON.get());
        this.registerDivinationRod((Item)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_RARE.get());
        this.registerDivinationRod((Item)ItemRegistry.SULFUR_ATTUNED_DIVINATION_ROD_PRECIOUS.get());
        this.registerDivinationRod((Item)ItemRegistry.AMETHYST_DIVINATION_ROD.get());
    }
}

