/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.function.BiConsumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class DistillationRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 100;

    public DistillationRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "distillation");
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        this.makeMercuryShardRecipe(1, (TagKey<Item>)Tags.Items.STONE, 10);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)Tags.Items.SANDSTONE, 10);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)ItemTags.f_13169_, 10);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)Tags.Items.COBBLESTONE, 10);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)Tags.Items.GRAVEL, 15);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)ItemTags.f_198160_, 25);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)Tags.Items.SAND, 15);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)Tags.Items.GLASS, 10);
        this.makeMercuryShardRecipe(5, ItemTagRegistry.LOW_MERCURY_ORES, 1);
        this.makeMercuryShardRecipe(25, ItemTagRegistry.MEDIUM_MERCURY_ORES, 1);
        this.makeMercuryShardRecipe(50, ItemTagRegistry.HIGH_MERCURY_ORES, 1);
        this.makeMercuryShardRecipe(1, ItemTagRegistry.LOW_MERCURY_RAW_MATERIALS, 1);
        this.makeMercuryShardRecipe(5, ItemTagRegistry.MEDIUM_MERCURY_RAW_MATERIALS, 1);
        this.makeMercuryShardRecipe(10, ItemTagRegistry.HIGH_MERCURY_RAW_MATERIALS, 1);
        this.makeMercuryShardRecipe(1, ItemTagRegistry.LOW_MERCURY_METALS, 1);
        this.makeMercuryShardRecipe(5, ItemTagRegistry.MEDIUM_MERCURY_METALS, 1);
        this.makeMercuryShardRecipe(10, ItemTagRegistry.HIGH_MERCURY_METALS, 1);
        this.makeMercuryShardRecipe(1, ItemTagRegistry.LOW_MERCURY_GEMS, 1);
        this.makeMercuryShardRecipe(5, ItemTagRegistry.MEDIUM_MERCURY_GEMS, 1);
        this.makeMercuryShardRecipe(10, ItemTagRegistry.HIGH_MERCURY_GEMS, 1);
        this.makeMercuryShardRecipe(1, ItemTagRegistry.LOW_MERCURY_OTHER_MINERALS, 1);
        this.makeMercuryShardRecipe(5, ItemTagRegistry.MEDIUM_MERCURY_OTHER_MINERALS, 1);
        this.makeMercuryShardRecipe(10, ItemTagRegistry.HIGH_MERCURY_OTHER_MINERALS, 1);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)Tags.Items.CROPS, 3);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)Tags.Items.DYES, 3);
        this.makeMercuryShardRecipe(1, Items.f_42485_, 2);
        this.makeMercuryShardRecipe(1, Items.f_42486_, 1);
        this.makeMercuryShardRecipe(1, Items.f_42579_, 2);
        this.makeMercuryShardRecipe(1, Items.f_42580_, 1);
        this.makeMercuryShardRecipe(1, Items.f_42581_, 2);
        this.makeMercuryShardRecipe(1, Items.f_42582_, 1);
        this.makeMercuryShardRecipe(1, Items.f_42526_, 2);
        this.makeMercuryShardRecipe(1, Items.f_42530_, 1);
        this.makeMercuryShardRecipe(1, Items.f_42527_, 2);
        this.makeMercuryShardRecipe(1, Items.f_42531_, 1);
        this.makeMercuryShardRecipe(1, Items.f_42697_, 2);
        this.makeMercuryShardRecipe(1, Items.f_42698_, 1);
        this.makeMercuryShardRecipe(1, Items.f_42406_, 1);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)ItemTags.f_13149_, 3);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)ItemTags.f_13180_, 3);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)ItemTags.f_13143_, 5);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)ItemTags.f_13182_, 2);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)ItemTags.f_13168_, 8);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)ItemTags.f_13167_, 1);
    }

    public void makeMercuryShardRecipe(int resultCount, TagKey<Item> ingredient, int ingredientCount) {
        this.makeMercuryShardRecipe(resultCount, ingredient, ingredientCount, 100);
    }

    public void makeMercuryShardRecipe(int resultCount, TagKey<Item> ingredient, int ingredientCount, int distillationTime) {
        this.makeMercuryShardRecipe(ingredient.f_203868_().m_135815_().replace("/", "."), resultCount, ingredient, ingredientCount, distillationTime);
    }

    public void makeMercuryShardRecipe(String recipeName, int resultCount, TagKey<Item> ingredient, int ingredientCount, int distillationTime) {
        JsonObject recipe = this.makeRecipeJson(this.makeTagIngredient(ingredient.f_203868_()), ingredientCount, this.makeItemResult(this.locFor((ItemLike)ItemRegistry.MERCURY_SHARD.get()), resultCount), distillationTime);
        JsonArray conditions = new JsonArray();
        conditions.add((JsonElement)this.makeTagNotEmptyCondition(ingredient.f_203868_().toString()));
        recipe.add("conditions", (JsonElement)conditions);
        this.recipeConsumer.accept(this.modLoc(recipeName), recipe);
    }

    public void makeMercuryShardRecipe(int resultCount, Item ingredient, int ingredientCount) {
        this.makeMercuryShardRecipe(resultCount, ingredient, ingredientCount, 100);
    }

    public void makeMercuryShardRecipe(int resultCount, Item ingredient, int ingredientCount, int distillationTime) {
        this.makeMercuryShardRecipe(ForgeRegistries.ITEMS.getKey((Object)ingredient).m_135815_(), resultCount, ingredient, ingredientCount, distillationTime);
    }

    public void makeMercuryShardRecipe(String recipeName, int resultCount, Item ingredient, int ingredientCount, int distillationTime) {
        this.recipeConsumer.accept(this.modLoc(recipeName), this.makeRecipeJson(this.makeItemIngredient(this.locFor((ItemLike)ingredient)), ingredientCount, this.makeItemResult(this.locFor((ItemLike)ItemRegistry.MERCURY_SHARD.get()), resultCount), distillationTime));
    }

    public JsonObject makeRecipeJson(JsonObject ingredient, int ingredientCount, JsonObject result, int distillationTime) {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", RecipeTypeRegistry.DISTILLATION.getId().toString());
        recipe.add("ingredient", (JsonElement)ingredient);
        recipe.addProperty("ingredient_count", (Number)ingredientCount);
        recipe.add("result", (JsonElement)result);
        recipe.addProperty("distillation_time", (Number)distillationTime);
        return recipe;
    }

    public String m_6055_() {
        return "Distillation Recipes";
    }
}

