/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.gui.controls;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class LabelWidget
extends AbstractWidget {
    public List<String> lines = new ArrayList<String>();
    public boolean centered = false;
    public boolean rightAligned = false;
    public int width = 0;
    public int margin = 2;
    public boolean shadow = false;

    public LabelWidget(int xIn, int yIn) {
        this(xIn, yIn, false);
    }

    public LabelWidget(int xIn, int yIn, boolean centered) {
        this(xIn, yIn, centered, -1, -1);
    }

    public LabelWidget(int xIn, int yIn, boolean centered, int width, int height) {
        this(xIn, yIn, centered, width, height, 2);
    }

    public LabelWidget(int xIn, int yIn, boolean centered, int width, int height, int margin) {
        this(xIn, yIn, centered, width, height, margin, 0xFFFFFF);
    }

    public LabelWidget(int xIn, int yIn, boolean centered, int width, int height, int margin, int color) {
        super(xIn, yIn, width, height, (Component)Component.m_237113_((String)""));
        this.centered = centered;
        this.width = width;
        this.margin = margin;
        this.packedFGColor = color;
        this.f_93623_ = false;
    }

    public void m_87963_(GuiGraphics guiGraphics, int p_268034_, int p_268009_, float p_268085_) {
        if (this.f_93624_) {
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontrenderer = minecraft.f_91062_;
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (this.centered && this.width <= 0 && this.lines.size() > 0) {
                this.width = fontrenderer.m_92895_(this.lines.get(0));
            }
            int color = this.getFGColor();
            for (int i = 0; i < this.lines.size(); ++i) {
                int n = this.m_252907_();
                Objects.requireNonNull(fontrenderer);
                int top = n + i * (9 + this.margin);
                if (this.centered) {
                    this.drawCenteredLabelString(guiGraphics, fontrenderer, this.lines.get(i), this.m_252754_(), top, color);
                    continue;
                }
                if (this.rightAligned) {
                    this.drawRightAlignedLabelString(guiGraphics, fontrenderer, this.lines.get(i), this.m_252754_(), top, color);
                    continue;
                }
                this.drawLabelString(guiGraphics, fontrenderer, this.lines.get(i), this.m_252754_(), top, color);
            }
        }
    }

    public void drawCenteredLabelString(GuiGraphics guiGraphics, Font font, String text, int x, int y, int color) {
        if (this.shadow) {
            guiGraphics.drawString(font, text, (float)(x - font.m_92895_(text) / 2), (float)y, color, true);
        } else {
            guiGraphics.drawString(font, text, (float)(x - font.m_92895_(text) / 2), (float)y, color, false);
        }
    }

    public void drawRightAlignedLabelString(GuiGraphics guiGraphics, Font font, String text, int x, int y, int color) {
        if (this.shadow) {
            guiGraphics.drawString(font, text, (float)(x - font.m_92895_(text)), (float)y, color, true);
        } else {
            guiGraphics.drawString(font, text, (float)(x - font.m_92895_(text)), (float)y, color, false);
        }
    }

    public void drawLabelString(GuiGraphics guiGraphics, Font font, String text, int x, int y, int color) {
        if (this.shadow) {
            guiGraphics.m_280056_(font, text, x, y, color, true);
        } else {
            guiGraphics.m_280056_(font, text, x, y, color, false);
        }
    }

    public LabelWidget alignRight(boolean align) {
        this.rightAligned = align;
        if (this.rightAligned) {
            this.centered = false;
        }
        return this;
    }

    public void addLine(String string, boolean translate) {
        if (translate) {
            this.addLine(I18n.m_118938_((String)string, (Object[])new Object[0]));
        } else {
            this.addLine(string);
        }
    }

    public void addLine(String string) {
        this.lines.add(string);
    }

    public void addLine(Component component) {
        this.lines.add(component.getString());
    }

    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }
}

