/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.goal;

import com.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.util.Math3DUtil;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class ReplantSaplingGoal
extends Goal {
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected BlockPos moveTarget = null;

    public ReplantSaplingGoal(SpiritEntity entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    private BlockPos getMoveTarget() {
        double angle = Math3DUtil.yaw(this.entity.m_20182_(), Math3DUtil.center(this.moveTarget));
        return this.moveTarget.m_121945_(Direction.m_122364_((double)angle).m_122424_());
    }

    public boolean m_8036_() {
        if (!this.entity.m_21120_(InteractionHand.MAIN_HAND).m_204117_(ItemTags.f_13180_)) {
            return false;
        }
        this.resetTarget();
        return this.moveTarget != null;
    }

    public boolean m_8045_() {
        return true;
    }

    public void m_8041_() {
        this.entity.m_21573_().m_26573_();
        this.resetTarget();
    }

    public void m_8037_() {
        if (this.moveTarget != null) {
            float accessDistance = 4.5f;
            double distance = this.entity.m_20182_().m_82554_(Math3DUtil.center(this.moveTarget));
            if (distance < (double)accessDistance) {
                this.entity.m_21573_().m_26573_();
            } else {
                BlockPos moveTarget = this.getMoveTarget();
                this.entity.m_21573_().m_26536_(this.entity.m_21573_().m_7864_(moveTarget, 0), 1.0);
            }
        } else {
            this.resetTarget();
        }
    }

    private void resetTarget() {
        this.moveTarget = null;
    }
}

