/*
 * Decompiled with CFR 0.152.
 */
package reliquary.block.tile;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import reliquary.block.tile.BlockEntityBase;
import reliquary.compat.jade.provider.IJadeDataChangeIndicator;
import reliquary.init.ModBlocks;
import reliquary.init.ModItems;
import reliquary.util.InventoryHelper;
import reliquary.util.WorldHelper;
import reliquary.util.potions.PotionIngredient;
import reliquary.util.potions.XRPotionHelper;

public class ApothecaryMortarBlockEntity
extends BlockEntityBase
implements IJadeDataChangeIndicator {
    public static final int PESTLE_USAGE_MAX = 5;
    private int pestleUsedCounter = 0;
    private boolean dataChanged = true;
    private long finishCoolDown;
    private final ItemStackHandler items = new ItemStackHandler(3){

        public int getSlotLimit(int slot) {
            return 1;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.isItemValid(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        private boolean isItemValid(ItemStack stack) {
            for (int i = 0; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).m_41619_() || this.getStackInSlot(i).m_41720_() != stack.m_41720_()) continue;
                return false;
            }
            return XRPotionHelper.isIngredient(stack) || XRPotionHelper.isItemEssence(stack);
        }

        protected void onContentsChanged(int slot) {
            ApothecaryMortarBlockEntity.this.dataChanged = true;
            WorldHelper.notifyBlockUpdate(ApothecaryMortarBlockEntity.this);
        }
    };

    public ApothecaryMortarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.APOTHECARY_MORTAR_TILE_TYPE.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items.deserializeNBT(tag.m_128469_("items"));
        this.pestleUsedCounter = tag.m_128448_("pestleUsed");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128376_("pestleUsed", (short)this.pestleUsedCounter);
        compound.m_128365_("items", (Tag)this.items.serializeNBT());
    }

    public NonNullList<ItemStack> getItemStacks() {
        return InventoryHelper.getItemStacks((IItemHandler)this.items);
    }

    public boolean usePestle(Level level) {
        int itemCount = 0;
        ArrayList<PotionIngredient> potionIngredients = new ArrayList<PotionIngredient>();
        for (ItemStack item : this.getItemStacks()) {
            if (item.m_41619_()) continue;
            ++itemCount;
            XRPotionHelper.getIngredient(item).ifPresent(potionIngredients::add);
        }
        if (itemCount > 1) {
            ++this.pestleUsedCounter;
            this.spawnPestleParticles(level);
        }
        return this.pestleUsedCounter >= 5 && this.createPotionEssence(potionIngredients, level);
    }

    private boolean createPotionEssence(List<PotionIngredient> potionIngredients, Level level) {
        List<MobEffectInstance> resultEffects = XRPotionHelper.combineIngredients(potionIngredients);
        if (resultEffects.isEmpty()) {
            this.pestleUsedCounter = 0;
            for (int clearSlot = 0; clearSlot < this.items.getSlots(); ++clearSlot) {
                if (this.items.getStackInSlot(clearSlot).m_41619_()) continue;
                if (!level.f_46443_) {
                    ItemEntity itemEntity = new ItemEntity(level, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, this.items.getStackInSlot(clearSlot).m_41777_());
                    level.m_7967_((Entity)itemEntity);
                }
                this.items.setStackInSlot(clearSlot, ItemStack.f_41583_);
            }
        } else {
            for (int clearSlot = 0; clearSlot < this.items.getSlots(); ++clearSlot) {
                this.items.setStackInSlot(clearSlot, ItemStack.f_41583_);
            }
            this.pestleUsedCounter = 0;
            this.finishCoolDown = level.m_46467_() + 20L;
            if (level.f_46443_) {
                return true;
            }
            ItemStack resultItem = new ItemStack((ItemLike)ModItems.POTION_ESSENCE.get());
            XRPotionHelper.addPotionEffectsToStack(resultItem, resultEffects);
            ItemEntity itemEntity = new ItemEntity(level, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, resultItem);
            level.m_7967_((Entity)itemEntity);
        }
        this.m_6596_();
        return false;
    }

    private void spawnPestleParticles(Level level) {
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.15, (double)this.m_58899_().m_123343_() + 0.5, 0.0, 0.1, 0.0);
    }

    public boolean isInCooldown(Level level) {
        return level.m_46467_() < this.finishCoolDown;
    }

    @Override
    public boolean getDataChanged() {
        boolean ret = this.dataChanged;
        this.dataChanged = false;
        return ret;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(() -> this.items));
        }
        return super.getCapability(cap, side);
    }

    public void dropItems(Level level) {
        InventoryHelper.dropInventoryItems(level, this.f_58858_, (IItemHandler)this.items);
    }

    public int getPestleUsedCounter() {
        return this.pestleUsedCounter;
    }
}

