/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import reliquary.init.ModEntities;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class EnderStaffProjectileEntity
extends ThrowableProjectile
implements ItemSupplier,
IEntityAdditionalSpawnData {
    private boolean normalGravity = false;

    public EnderStaffProjectileEntity(EntityType<EnderStaffProjectileEntity> entityType, Level world) {
        super(entityType, world);
    }

    public EnderStaffProjectileEntity(Level world, Player entityPlayer, boolean shortRange) {
        super((EntityType)ModEntities.ENDER_STAFF_PROJECTILE.get(), (LivingEntity)entityPlayer, world);
        this.normalGravity = shortRange;
    }

    protected float m_7139_() {
        if (this.normalGravity) {
            return super.m_7139_();
        }
        return 0.005f;
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 4 == this.m_9236_().f_46441_.m_188503_(5)) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 1.0);
        }
        if (this.m_20069_()) {
            this.onThrowableCollision((HitResult)new BlockHitResult(this.m_20182_(), Direction.UP, this.m_20183_(), true));
        }
    }

    protected void m_20101_() {
        super.m_20101_();
        Vec3 deltaMovement = this.m_20184_();
        double tinyScaleUp = 1.008;
        this.m_20334_(deltaMovement.f_82479_ * tinyScaleUp, deltaMovement.f_82480_, deltaMovement.f_82481_ * tinyScaleUp);
    }

    protected void m_6532_(HitResult result) {
        this.onThrowableCollision(result);
    }

    private void onThrowableCollision(HitResult result) {
        Entity thrower = this.m_19749_();
        if (!(thrower instanceof Player) || (int)this.m_20186_() <= 0) {
            this.m_146870_();
            return;
        }
        for (int i = 0; i < 32; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_(), this.m_20186_() + this.f_19796_.m_188500_() * 2.0, this.m_20189_(), this.f_19796_.m_188583_(), 0.0, this.f_19796_.m_188583_());
        }
        if (!this.m_9236_().f_46443_) {
            thrower.f_19789_ = 0.0f;
            int x = (int)Math.round(this.m_20185_());
            int y = (int)Math.round(this.m_20186_());
            int z = (int)Math.round(this.m_20189_());
            if (result.m_6662_() != HitResult.Type.MISS) {
                BlockPos pos;
                if (result.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entityHit = ((EntityHitResult)result).m_82443_();
                    entityHit.m_6469_(this.m_269291_().m_269390_((Entity)this, thrower), 0.0f);
                    pos = entityHit.m_20183_();
                } else {
                    BlockHitResult blockResult = (BlockHitResult)result;
                    pos = blockResult.m_82425_().m_121945_(blockResult.m_82434_());
                }
                y = pos.m_123342_();
                x = pos.m_123341_();
                z = pos.m_123343_();
            }
            float targetX = (float)x + 0.5f;
            float targetY = (float)y + 0.5f;
            float targetZ = (float)z + 0.5f;
            if (thrower instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)thrower;
                ForgeEventFactory.onEnderPearlLand((ServerPlayer)serverPlayer, (double)targetX, (double)targetY, (double)targetZ, (ThrownEnderpearl)new ThrownEnderpearl(this.m_9236_(), (LivingEntity)serverPlayer), (float)0.0f, (HitResult)result);
            }
            thrower.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            thrower.m_6021_((double)targetX, (double)targetY, (double)targetZ);
        }
        this.m_146870_();
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)Items.f_42584_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.normalGravity);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.normalGravity = additionalData.readBoolean();
    }
}

