/*
 * Decompiled with CFR 0.152.
 */
package reliquary.init;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import reliquary.block.AlkahestryAltarBlock;
import reliquary.block.ApothecaryCauldronBlock;
import reliquary.block.ApothecaryMortarBlock;
import reliquary.block.FertileLilyPadBlock;
import reliquary.block.InterdictionTorchBlock;
import reliquary.block.PassivePedestalBlock;
import reliquary.block.PedestalBlock;
import reliquary.block.WallInterdictionTorchBlock;
import reliquary.block.WraithNodeBlock;
import reliquary.block.tile.AlkahestryAltarBlockEntity;
import reliquary.block.tile.ApothecaryCauldronBlockEntity;
import reliquary.block.tile.ApothecaryMortarBlockEntity;
import reliquary.block.tile.PassivePedestalBlockEntity;
import reliquary.block.tile.PedestalBlockEntity;
import reliquary.item.block.BlockItemBase;
import reliquary.item.block.FertileLilyPadItem;
import reliquary.item.block.InterdictionTorchItem;

public class ModBlocks {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"reliquary");
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"reliquary");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"reliquary");
    private static final String ALKAHESTRY_ALTAR_REGISTRY_NAME = "alkahestry_altar";
    private static final String INTERDICTION_TORCH_REGISTRY_NAME = "interdiction_torch";
    private static final String APOTHECARY_CAULDRON_REGISTRY_NAME = "apothecary_cauldron";
    private static final String APOTHECARY_MORTAR_REGISTRY_NAME = "apothecary_mortar";
    private static final String FERTILE_LILY_PAD_REGISTRY_NAME = "fertile_lily_pad";
    private static final String WRAITH_NODE_REGISTRY_NAME = "wraith_node";
    public static final RegistryObject<AlkahestryAltarBlock> ALKAHESTRY_ALTAR = BLOCKS.register("alkahestry_altar", AlkahestryAltarBlock::new);
    public static final RegistryObject<ApothecaryCauldronBlock> APOTHECARY_CAULDRON = BLOCKS.register("apothecary_cauldron", ApothecaryCauldronBlock::new);
    public static final RegistryObject<ApothecaryMortarBlock> APOTHECARY_MORTAR = BLOCKS.register("apothecary_mortar", ApothecaryMortarBlock::new);
    public static final RegistryObject<FertileLilyPadBlock> FERTILE_LILY_PAD = BLOCKS.register("fertile_lily_pad", FertileLilyPadBlock::new);
    public static final RegistryObject<InterdictionTorchBlock> INTERDICTION_TORCH = BLOCKS.register("interdiction_torch", InterdictionTorchBlock::new);
    public static final RegistryObject<WallInterdictionTorchBlock> WALL_INTERDICTION_TORCH = BLOCKS.register("wall_interdiction_torch", WallInterdictionTorchBlock::new);
    public static final RegistryObject<WraithNodeBlock> WRAITH_NODE = BLOCKS.register("wraith_node", WraithNodeBlock::new);
    public static final Map<DyeColor, RegistryObject<PassivePedestalBlock>> PASSIVE_PEDESTALS;
    public static final Map<DyeColor, RegistryObject<PedestalBlock>> PEDESTALS;
    public static final RegistryObject<BlockEntityType<AlkahestryAltarBlockEntity>> ALKAHESTRY_ALTAR_TILE_TYPE;
    public static final RegistryObject<BlockEntityType<PedestalBlockEntity>> PEDESTAL_TILE_TYPE;
    public static final RegistryObject<BlockEntityType<PassivePedestalBlockEntity>> PASSIVE_PEDESTAL_TILE_TYPE;
    public static final RegistryObject<BlockEntityType<ApothecaryCauldronBlockEntity>> APOTHECARY_CAULDRON_TILE_TYPE;
    public static final RegistryObject<BlockEntityType<ApothecaryMortarBlockEntity>> APOTHECARY_MORTAR_TILE_TYPE;
    public static final RegistryObject<BlockItemBase> ALKAHESTRY_ALTAR_ITEM;
    public static final RegistryObject<BlockItemBase> APOTHECARY_CAULDRON_ITEM;
    public static final RegistryObject<BlockItemBase> APOTHECARY_MORTAR_ITEM;
    public static final RegistryObject<BlockItemBase> FERTILE_LILY_PAD_ITEM;
    public static final RegistryObject<BlockItemBase> WRAITH_NODE_ITEM;
    public static final RegistryObject<InterdictionTorchItem> INTERDICTION_TORCH_ITEM;
    public static final Map<DyeColor, RegistryObject<BlockItem>> PEDESTAL_ITEMS;
    public static final Map<DyeColor, RegistryObject<BlockItem>> PASSIVE_PEDESTAL_ITEMS;
    private static final String BLOCK_PREFIX = "block.";

    private ModBlocks() {
    }

    public static void registerListeners(IEventBus modBus) {
        ITEMS.register(modBus);
        BLOCKS.register(modBus);
        BLOCK_ENTITY_TYPES.register(modBus);
    }

    private static <T extends BlockEntity> BlockEntityType<T> getTileEntityType(BlockEntityType.BlockEntitySupplier<T> tileFactory, Block ... validBlocks) {
        return BlockEntityType.Builder.m_155273_(tileFactory, (Block[])validBlocks).m_58966_(null);
    }

    static {
        ImmutableMap.Builder passiveBuilder = ImmutableMap.builder();
        ImmutableMap.Builder activeBuilder = ImmutableMap.builder();
        for (DyeColor color : DyeColor.values()) {
            passiveBuilder.put((Object)color, (Object)BLOCKS.register("pedestals/passive/" + color.m_41065_() + "_passive_pedestal", PassivePedestalBlock::new));
            activeBuilder.put((Object)color, (Object)BLOCKS.register("pedestals/" + color.m_41065_() + "_pedestal", PedestalBlock::new));
        }
        PASSIVE_PEDESTALS = passiveBuilder.build();
        PEDESTALS = activeBuilder.build();
        ALKAHESTRY_ALTAR_TILE_TYPE = BLOCK_ENTITY_TYPES.register(ALKAHESTRY_ALTAR_REGISTRY_NAME, () -> ModBlocks.getTileEntityType(AlkahestryAltarBlockEntity::new, (Block)ALKAHESTRY_ALTAR.get()));
        PEDESTAL_TILE_TYPE = BLOCK_ENTITY_TYPES.register("pedestal", () -> ModBlocks.getTileEntityType(PedestalBlockEntity::new, (Block[])PEDESTALS.values().stream().map(RegistryObject::get).toArray(PedestalBlock[]::new)));
        PASSIVE_PEDESTAL_TILE_TYPE = BLOCK_ENTITY_TYPES.register("passive_pedestal", () -> ModBlocks.getTileEntityType(PassivePedestalBlockEntity::new, (Block[])PASSIVE_PEDESTALS.values().stream().map(RegistryObject::get).toArray(PassivePedestalBlock[]::new)));
        APOTHECARY_CAULDRON_TILE_TYPE = BLOCK_ENTITY_TYPES.register(APOTHECARY_CAULDRON_REGISTRY_NAME, () -> ModBlocks.getTileEntityType(ApothecaryCauldronBlockEntity::new, (Block)APOTHECARY_CAULDRON.get()));
        APOTHECARY_MORTAR_TILE_TYPE = BLOCK_ENTITY_TYPES.register(APOTHECARY_MORTAR_REGISTRY_NAME, () -> ModBlocks.getTileEntityType(ApothecaryMortarBlockEntity::new, (Block)APOTHECARY_MORTAR.get()));
        ALKAHESTRY_ALTAR_ITEM = ITEMS.register(ALKAHESTRY_ALTAR_REGISTRY_NAME, () -> new BlockItemBase((Block)ALKAHESTRY_ALTAR.get()));
        APOTHECARY_CAULDRON_ITEM = ITEMS.register(APOTHECARY_CAULDRON_REGISTRY_NAME, () -> new BlockItemBase((Block)APOTHECARY_CAULDRON.get()));
        APOTHECARY_MORTAR_ITEM = ITEMS.register(APOTHECARY_MORTAR_REGISTRY_NAME, () -> new BlockItemBase((Block)APOTHECARY_MORTAR.get()));
        FERTILE_LILY_PAD_ITEM = ITEMS.register(FERTILE_LILY_PAD_REGISTRY_NAME, FertileLilyPadItem::new);
        WRAITH_NODE_ITEM = ITEMS.register(WRAITH_NODE_REGISTRY_NAME, () -> new BlockItemBase((Block)WRAITH_NODE.get()));
        INTERDICTION_TORCH_ITEM = ITEMS.register(INTERDICTION_TORCH_REGISTRY_NAME, InterdictionTorchItem::new);
        passiveBuilder = ImmutableMap.builder();
        activeBuilder = ImmutableMap.builder();
        for (DyeColor color : DyeColor.values()) {
            passiveBuilder.put((Object)color, (Object)ITEMS.register("pedestals/passive/" + color.m_41065_() + "_passive_pedestal", () -> new BlockItemBase((Block)PASSIVE_PEDESTALS.get(color).get(), new Item.Properties()){

                public Component m_7626_(ItemStack stack) {
                    return Component.m_237115_((String)"block.reliquary.passive_pedestal");
                }

                public String m_5524_() {
                    return "block.reliquary.passive_pedestal";
                }
            }));
            activeBuilder.put((Object)color, (Object)ITEMS.register("pedestals/" + color.m_41065_() + "_pedestal", () -> new BlockItemBase((Block)PEDESTALS.get(color).get(), new Item.Properties()){

                public Component m_7626_(ItemStack stack) {
                    return Component.m_237115_((String)"block.reliquary.pedestal");
                }

                public String m_5524_() {
                    return "block.reliquary.pedestal";
                }
            }));
        }
        PASSIVE_PEDESTAL_ITEMS = passiveBuilder.build();
        PEDESTAL_ITEMS = activeBuilder.build();
    }
}

