/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import reliquary.handler.CommonEventHandler;
import reliquary.handler.HandlerPriority;
import reliquary.handler.IPlayerHurtHandler;
import reliquary.init.ModItems;
import reliquary.item.ItemBase;
import reliquary.reference.Settings;
import reliquary.util.InventoryHelper;

public class InfernalClawsItem
extends ItemBase {
    public InfernalClawsItem() {
        super(new Item.Properties().m_41487_(1));
        CommonEventHandler.registerPlayerHurtHandler(new IPlayerHurtHandler(){

            @Override
            public boolean canApply(Player player, LivingAttackEvent event) {
                return (event.getSource() == player.m_269291_().m_269387_() || event.getSource() == player.m_269291_().m_269549_()) && player.m_36324_().m_38702_() > 0 && InventoryHelper.playerHasItem(player, (Item)ModItems.INFERNAL_CLAWS.get());
            }

            @Override
            public boolean apply(Player player, LivingAttackEvent event) {
                player.m_36399_(event.getAmount() * ((float)((Integer)Settings.COMMON.items.infernalClaws.hungerCostPercent.get()).intValue() / 100.0f));
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.HIGH;
            }
        });
    }

    @Override
    public MutableComponent getName(ItemStack stack) {
        return super.getName(stack).m_130940_(ChatFormatting.RED);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return true;
    }
}

