/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.core.proxy;

import com.google.common.collect.ImmutableMap;
import de.melanx.aiotbotania.config.CommonConfig;
import de.melanx.aiotbotania.core.Registration;
import de.melanx.aiotbotania.core.network.AIOTBotaniaNetwork;
import de.melanx.aiotbotania.core.proxy.IProxy;
import de.melanx.aiotbotania.items.alfsteel.CustomPylonRepairable;
import de.melanx.aiotbotania.items.alfsteel.RecipeAlfsteelAIOT;
import de.melanx.aiotbotania.items.alfsteel.RecipeAlfsteelAIOTTipped;
import de.melanx.aiotbotania.items.terrasteel.RecipeTerraSteelAIOT;
import de.melanx.aiotbotania.items.terrasteel.RecipeTerraSteelAIOTTipped;
import de.melanx.aiotbotania.util.ToolUtil;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.common.item.BotaniaItems;

public class CommonProxy
implements IProxy {
    public static final ResourceLocation TERRA_RECIPE_ID = new ResourceLocation("aiotbotania", "recipe_terrasteel_aiot");
    public static final ResourceLocation TERRA_RECIPE_ID_TIPPED = new ResourceLocation("aiotbotania", "recipe_terrasteel_aiot_tipped");
    public static final ResourceLocation ALFSTEEL_RECIPE_ID = new ResourceLocation("aiotbotania", "recipe_alfsteel_aiot");
    public static final ResourceLocation ALFSTEEL_RECIPE_ID_TIPPED = new ResourceLocation("aiotbotania", "recipe_alfsteel_aiot_tipped");
    public static boolean LOCKED = false;

    public CommonProxy() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(this::onReload);
        MinecraftForge.EVENT_BUS.addListener(this::onTilt);
    }

    public void setup(FMLCommonSetupEvent event) {
        AIOTBotaniaNetwork.registerPackets();
        if (ModList.get().isLoaded("mythicbotany")) {
            CustomPylonRepairable.pylonRepairable().run();
        }
        Registration.registerDispenseBehavior();
    }

    public void onReload(final AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Object>(){

            @Nonnull
            protected Object m_5944_(@Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller profiler) {
                return new Object();
            }

            protected void m_5787_(@Nonnull Object object, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller profiler) {
                if (((Boolean)CommonConfig.terraAiot.get()).booleanValue() || ModList.get().isLoaded("mythicbotany")) {
                    RecipeManager recipeManager = event.getServerResources().m_206887_();
                    Map recipes = (Map)ObfuscationReflectionHelper.getPrivateValue(RecipeManager.class, (Object)recipeManager, (String)"f_44007_");
                    Map recipesNew = (Map)recipes.entrySet().stream().map(entry -> {
                        if (entry.getKey() == RecipeType.f_44107_) {
                            return Pair.of((Object)((RecipeType)entry.getKey()), this.insertRecipe((Map)entry.getValue()));
                        }
                        return entry;
                    }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
                    ObfuscationReflectionHelper.setPrivateValue(RecipeManager.class, (Object)recipeManager, (Object)recipesNew, (String)"f_44007_");
                }
            }

            private Map<ResourceLocation, Recipe<?>> insertRecipe(Map<ResourceLocation, Recipe<?>> recipeMap) {
                ImmutableMap.Builder builder = ImmutableMap.builder().putAll(recipeMap);
                if (((Boolean)CommonConfig.terraAiot.get()).booleanValue()) {
                    builder.put((Object)TERRA_RECIPE_ID, (Object)new RecipeTerraSteelAIOT(TERRA_RECIPE_ID, "terrasteel_aiot")).put((Object)TERRA_RECIPE_ID_TIPPED, (Object)new RecipeTerraSteelAIOTTipped(TERRA_RECIPE_ID_TIPPED, "recipe_terrasteel_aiot_tipped"));
                }
                if (ModList.get().isLoaded("mythicbotany")) {
                    builder.put((Object)ALFSTEEL_RECIPE_ID, (Object)new RecipeAlfsteelAIOT(ALFSTEEL_RECIPE_ID, "recipe_alfsteel_aiot")).put((Object)ALFSTEEL_RECIPE_ID_TIPPED, (Object)new RecipeAlfsteelAIOTTipped(ALFSTEEL_RECIPE_ID_TIPPED, "recipe_alfsteel_aiot_tipped"));
                }
                return builder.build();
            }
        });
    }

    public void onTilt(BlockEvent.BlockToolModificationEvent event) {
        UseOnContext context = event.getContext();
        if (LOCKED || event.getToolAction() != ToolActions.HOE_TILL || context.m_43725_().f_46443_) {
            return;
        }
        ItemStack stack = context.m_43722_();
        if (stack.m_41720_() == BotaniaItems.elementiumHoe || stack.m_41720_() == BotaniaItems.manasteelHoe) {
            LOCKED = true;
            InteractionResult resultType = ToolUtil.hoeUse(context, stack.m_41720_() == BotaniaItems.elementiumHoe, false);
            if (resultType != InteractionResult.PASS) {
                event.setCanceled(true);
                if (event.getPlayer() != null) {
                    event.getPlayer().m_21011_(InteractionHand.MAIN_HAND, true);
                }
            }
            LOCKED = false;
        }
    }
}

