/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.jei;

import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.Blcks;
import owmii.powah.block.Tier;

public class MagmatorCategory
implements IRecipeCategory<Recipe> {
    public static final RecipeType<Recipe> TYPE = RecipeType.create((String)"powah", (String)"magmatic", Recipe.class);
    public static final ResourceLocation GUI_BACK = new ResourceLocation("powah", "textures/gui/jei/misc.png");
    private final IDrawable background;
    private final IDrawable icon;

    public MagmatorCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GUI_BACK, 0, 0, 160, 24).addPadding(1, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blcks.MAGMATOR.get(Tier.BASIC)));
    }

    public RecipeType<Recipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.powah.jei.category.magmatic");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 5).addFluidStack(recipe.fluid(), FluidStack.bucketAmount());
    }

    public void draw(Recipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        guiGraphics.m_280056_(minecraft.f_91062_, recipe.heat + " FE/100 mb", 27, 9, 0x444444, false);
    }

    public static List<Recipe> getRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        for (Map.Entry entry : BuiltInRegistries.f_257020_.m_6579_()) {
            ResourceLocation fluidId = ((ResourceKey)entry.getKey()).m_135782_();
            Integer heat = PowahAPI.MAGMATIC_FLUIDS.get(fluidId);
            if (heat == null) continue;
            recipes.add(new Recipe((Fluid)entry.getValue(), heat));
        }
        recipes.sort(Comparator.comparingInt(Recipe::heat));
        return recipes;
    }

    public record Recipe(Fluid fluid, int heat) {
    }
}

